﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using YamlDotNet.Serialization;
using System.Text.RegularExpressions;
using CommandUtility;

namespace MakeInitialImage
{
    public class YamlConverterOfByteUnitExpression : IYamlTypeConverter
    {
        public bool Accepts(Type type)
        {
            return type == typeof(ByteUnitExpression);
        }

        public object ReadYaml(YamlDotNet.Core.IParser parser, Type type)
        {
            var value = ((YamlDotNet.Core.Events.Scalar)parser.Current).Value;
            parser.MoveNext();
            return ByteUnitExpression.Parse(value);
        }

        public void WriteYaml(YamlDotNet.Core.IEmitter emitter, object value, Type type)
        {
            emitter.Emit(new YamlDotNet.Core.Events.Scalar(((ByteUnitExpression)value).ToString()));
        }
    }

    public class InitialImageConfigParser
    {
        public static InitialImageConfig Parse(TextReader textReader, Dictionary<string, string> variables)
        {
            var text = textReader.ReadToEnd();
            var replacedText = Utility.ReplaceVariables(text, variables);
            using (var replacedTextReader = new StringReader(replacedText))
            {
                var deserializer = new Deserializer();
                deserializer.RegisterTypeConverter(new YamlConverterOfByteUnitExpression());
                return deserializer.Deserialize<InitialImageConfig>(replacedTextReader);
            }
        }

        public static InitialImageConfig Parse(FileInfo fileInfo, Dictionary<string, string> variables)
        {
            using (var textReader = fileInfo.OpenText())
            {
                return Parse(textReader, variables);
            }
        }

        public static InitialImageConfig Parse(TextReader textReader)
        {
            return Parse(textReader, new Dictionary<string, string>());
        }

        public static InitialImageConfig Parse(FileInfo fileInfo)
        {
            using (var textReader = fileInfo.OpenText())
            {
                return Parse(textReader);
            }
        }
    }
}
