﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace MakeInitialImage
{
    public class GuidPartitionTableReader
    {
        public Stream Reader { get; set; }
        public ProtectiveMbr ProtectiveMbr { get; set; }
        public GptHeader GptHeader { get; set; }
        public List<GptPartitionEntry> PartitionEntries { get; set; }

        public GuidPartitionTableReader(Stream reader)
        {
            this.Reader = reader;

            this.ProtectiveMbr = ReadMbr();
            this.GptHeader = ReadHeader();

            this.Reader.Seek(512 * 2, SeekOrigin.Begin);

            this.PartitionEntries = (from  i in Enumerable.Range(0, GptHeader.NumberOfPartitionEntries)
                                    select Utility.ReadBinary<GptPartitionEntry>(reader)).ToList();
        }

        private GptHeader ReadHeader()
        {
            return Utility.ReadBinary<GptHeader>(this.Reader);
        }

        private ProtectiveMbr ReadMbr()
        {
            return Utility.ReadBinary<ProtectiveMbr>(this.Reader);
        }
    }
}
