﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using CommandUtility;

namespace MakeInitialImage
{
    class ApplicationInstallProcessor : IFatImagePreprocessor
    {
        public ApplicationInstallProcessor(DirectoryInfo userDirectory, List<FileInfo> installedNspFiles, TemporaryFileHolder tempHolder)
        {
            UserDirectory = userDirectory;
            InstalledNspFiles = installedNspFiles;
            TemporaryFileHolder = tempHolder;
        }

        public void Process(DirectoryInfo storageDirectory)
        {
            // InstallApp のパスを取得する
            var installApp = SdkPath.FindToolPath("InstallAppOnHost.exe");
            var installAppManifest = new FileInfo(installApp.FullName + ".manifest");
            var ncaKeyConfig = installApp.Directory.CombineAsFile("ncaKeyConfig.tdf");

            // 一時ディレクトリを作る
            var installAppDir = TemporaryFileHolder.CreateTemporaryDirectory("InstallApp");

            // exe をコピーする
            var copiedToolPath = installApp.CopyTo(installAppDir);
            installAppManifest.CopyTo(installAppDir);
            ncaKeyConfig.CopyTo(installAppDir);

            foreach (var nspPath in InstalledNspFiles)
            {
                var outputs = new StringBuilder();

                try
                {
                    SdkTool.Execute(
                        copiedToolPath,
                        new string[] {
                            nspPath.FullName,
                            storageDirectory.FullName,
                            UserDirectory.FullName
                        },
                        output: outputs);
                }
                catch (Exception e)
                {
                    Console.Error.WriteLine($"Error in installing the Application: {e.Message}");
                    Console.Error.WriteLine($"Nsp: {nspPath.FullName}");
                    Console.Error.WriteLine($"Outputs: {outputs.ToString()}");
                    throw;
                }
            }
        }

        private DirectoryInfo UserDirectory;
        private List<FileInfo> InstalledNspFiles;
        TemporaryFileHolder TemporaryFileHolder;
    }
}
