﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace Nintendo.Log
{
    class ProgressBox : Form
    {
        public ProgressBox(string title, string message)
        {
            const int Margin = 10;

            messageLabel = new Label();
            progressBar = new ProgressBar();
            cancelButton = new Button();

            messageLabel.Text = message;
            messageLabel.Location = new Point(Margin, Margin);
            messageLabel.AutoSize = true;

            progressBar.Location = new Point(Margin, messageLabel.Bottom + Margin);
            progressBar.Width = messageLabel.PreferredWidth;
            progressBar.Minimum = 0;
            progressBar.Maximum = ProgressAccuracy;

            cancelButton.Text = "Cancel";
            cancelButton.DialogResult = DialogResult.Cancel;
            cancelButton.Location = new Point(progressBar.Right - cancelButton.Width, progressBar.Bottom + Margin);

            this.Text = title;
            this.ClientSize = new Size(progressBar.Width + Margin * 2, cancelButton.Bottom + Margin);
            this.FormBorderStyle = FormBorderStyle.FixedDialog;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.ControlBox = false;
            this.MinimizeBox = false;
            this.MaximizeBox = false;
            this.CancelButton = cancelButton;
            this.Controls.AddRange(new Control[] { messageLabel, progressBar, cancelButton });
        }

        public void SetProgress(double progressPercentage)
        {
            if (!(0.0 <= progressPercentage && progressPercentage <= 1.0))
            {
                throw new ArgumentException();
            }
            Invoke((MethodInvoker)(() =>
            {
                progressBar.Value = (int)(progressPercentage * ProgressAccuracy);
            }));
        }

        const int ProgressAccuracy = 1000000;

        private Label messageLabel;
        private ProgressBar progressBar;
        private Button cancelButton;
    }
}
