﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks.Dataflow;
using System.Web.Script.Serialization;

namespace Nintendo.Log
{
    class JsonLogPort : IDisposable
    {
        public JsonLogPort(string peerName, string portName, ISourceBlock<Dictionary<string, object>> sourceBlock)
        {
            TrasnformBlockLinkDisposer = sourceBlock.LinkTo(TransformBlock,
                log => (string)log["PeerName"] == peerName);

            LogPortEmulator = new LogPortEmulator(peerName, portName, TransformBlock);
        }

        public void Dispose()
        {
            TransformBlock.Complete();
            TransformBlock.Completion.Wait();
            TrasnformBlockLinkDisposer.Dispose();
            LogPortEmulator.Dispose();
        }

        TransformBlock<Dictionary<string, object>, string> TransformBlock =
            new TransformBlock<Dictionary<string, object>, string>(
                log =>
                {
#if false // パース可能な JSON を生成していることを確認したいときに true にする。
                    var text = LogConverter.ToJsonText(log, IsPretty);
                    var serializer = new JavaScriptSerializer();
                    var dictionary = serializer.Deserialize<Dictionary<string, object>>(text);
                    return dictionary.ContainsKey("TextLog")
                        ? (string)dictionary["TextLog"]
                        : string.Empty;
#else
                    return LogConverter.ToJsonText(log, IsPretty) + Environment.NewLine;
#endif
                });

        private static readonly bool IsPretty = false; // 整形された JSON で確認したいときに true にする。
        private IDisposable TrasnformBlockLinkDisposer;
        LogPortEmulator LogPortEmulator;
    }
}
