﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Web.Script.Serialization;

namespace Nintendo.Log
{
    static class JsonLogParser
    {
        private static void ThrowUnless<T>(bool isSuccess) where T : Exception, new()
        {
            if (!isSuccess)
            {
                throw new T();
            }
        }

        public static IEnumerable<Dictionary<string, object>> Parse(string path)
        {
            var serializer = new JavaScriptSerializer();

            using (var sr = new StreamReader(path, new UTF8Encoding(false)))
            {
                ThrowUnless<InvalidDataException>(!sr.EndOfStream && sr.ReadLine() == "[");

                bool isFirst = true;
                string line;
                do
                {
                    line = sr.ReadLine();

                    if (isFirst)
                    {
                        isFirst = false;
                        if (line == "]")
                        {
                            yield break; // ログが 0 個のとき。
                        }
                    }

                    ThrowUnless<InvalidDataException>(line.StartsWith("{"));
                    ThrowUnless<InvalidDataException>(line.EndsWith("}") || line.EndsWith("},"));

                    var objectString = line.Substring(0, line.LastIndexOf('}') + 1); // '{' から '}' まで。

                    yield return serializer.Deserialize<Dictionary<string, object>>(objectString);

                } while (line.EndsWith("},"));

                ThrowUnless<InvalidDataException>(!sr.EndOfStream && sr.ReadLine() == "]");
            }
        }
    }
}
