﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.HtcTools
{
    public sealed class HtclowReader : IDisposable
    {
        private readonly HtclowChannel m_Channel;
        private readonly bool m_LeaveOpen;

        public HtclowReader(HtclowChannel channel)
            : this(channel, false)
        {
        }

        public HtclowReader(HtclowChannel channel, bool leaveOpen)
        {
            m_Channel = channel;
            m_LeaveOpen = leaveOpen;
        }

        public byte[] Read(int length)
        {
            return m_Channel.Receive(length);
        }

        public short ReadInt16()
        {
            return BitConverter.ToInt16(Read(sizeof(short)), 0);
        }

        public ushort ReadUInt16()
        {
            return BitConverter.ToUInt16(Read(sizeof(ushort)), 0);
        }

        public int ReadInt32()
        {
            return BitConverter.ToInt32(Read(sizeof(int)), 0);
        }

        public uint ReadUInt32()
        {
            return BitConverter.ToUInt32(Read(sizeof(uint)), 0);
        }

        public long ReadInt64()
        {
            return BitConverter.ToInt64(Read(sizeof(long)), 0);
        }

        public ulong ReadUInt64()
        {
            return BitConverter.ToUInt64(Read(sizeof(long)), 0);
        }

        public string ReadString(int length)
        {
            return Encoding.UTF8.GetString(Read(length));
        }

        public void Dispose()
        {
            if (!m_LeaveOpen)
            {
                m_Channel.Dispose();
            }
        }
    }
}
