﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.HtcTools
{
    public class HtclowModule
    {
        private readonly Htclow.Mux m_Mux;
        private readonly byte m_ModuleId;

        internal HtclowModule(Htclow.Mux mux, byte moduleId)
        {
            m_Mux = mux;
            m_ModuleId = moduleId;
        }

        public HtclowChannel OpenChannel(ushort channelId)
        {
            return new HtclowChannel(m_Mux, m_ModuleId, channelId);
        }
    }
}
