﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace Nintendo.HtcTools.HtcfsLibrary
{
    internal class Constants
    {
        public const short Protocol = 1;
        public const byte HtclowModuleId = 1;
        public const ushort HtclowChannelId = 0;
        public const short MaxVersion = 1;
    }

    internal enum PacketCategory : short
    {
        Request = 0x0000,
        Response = 0x0001,
    }

    internal enum DirectoryEntryType : int
    {
        Directory = 0,
        File = 1,
    }

    [Flags]
    internal enum OpenDirectoryMode : int
    {
        Directory = 1,
        File = 2,
        All = 3,
    }

    [Flags]
    internal enum OpenMode : int
    {
        Read = 1,
        Write = 2,
        AllowAppend = 4,
    }

    internal enum PacketType : short
    {
        GetMaxProtocolVersion = 0x00,
        SetProtocolVersion = 0x01,
        GetEntryType = 0x10,
        OpenFile = 0x20,
        CloseFile = 0x21,
        GetPriorityForFile = 0x22,
        SetPriorityForFile = 0x23,
        CreateFile = 0x24,
        DeleteFile = 0x25,
        RenameFile = 0x26,
        FileExists = 0x27,
        ReadFile = 0x28,
        WriteFile = 0x29,
        FlushFile = 0x2a,
        GetFileTimeStamp = 0x2b,
        GetFileSize = 0x2c,
        SetFileSize = 0x2d,
        OpenDirectory = 0x30,
        CloseDirectory = 0x31,
        GetPriorityForDirectory = 0x32,
        SetPriorityForDirectory = 0x33,
        CreateDirectory = 0x34,
        DeleteDirectory = 0x35,
        RenameDirectory = 0x36,
        DirectoryExists = 0x37,
        ReadDirectory = 0x38,
        GetEntryCount = 0x39,
    }

    internal enum HtcfsResult : int
    {
        Success = 0,
        UnknownError = 1,
        UnsupportedVersion = 2,
        InvalidRequest = 3,
        InvalidHandle = 4,
        OutOfHandle = 5,
    }

    internal enum WriteOption : int
    {
        Flush = 1,
    }

    internal class DirectoryEntry
    {
        public DirectoryEntryType EntryType { get; set; }
        public long Size { get; set; }
        public string Name { get; set; }
    }
}
