﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/os.h>
#include "CrashReportRaw.h"

namespace nn { namespace creport {

class CrashReport
{
public:
    void ParseRawData(CrashReportRaw& raw)
    {
        version = raw.header.version;

        switch (raw.header.version)
        {
        case 1:
            ParseRawDataV1(raw.data.dataV1);
            break;
        case 2:
            ParseRawDataV2(raw.data.dataV2);
            break;
        case 3:
            ParseRawDataV3(raw.data.dataV3);
            break;
        default:
            NN_ABORT("未対応のバージョンです\n");
            break;
        }
    }

    void Dump();
    void ShowStackTraceHash();

private:
    void ShowCodeAddress(nn::Bit64 addr);
    void ParseRawDataV1(CrashReportRawDataV1& raw);
    void ParseRawDataV2(CrashReportRawDataV2& raw);
    void ParseRawDataV3(CrashReportRawDataV3& raw);
    nn::Bit64 GetModuleOffset(nn::Bit64 addr);

private:
    struct ModuleInfo
    {
        char  moduleName[32];
        Bit64 codeBase;
        Bit64 codeEnd;
    };

    struct ThreadInfo
    {
        nn::Bit64              threadId;
        nn::Bit64              reg[29];
        nn::Bit64              fp;
        nn::Bit64              lr;
        nn::Bit64              sp;
        nn::Bit64              pc;
        nn::Bit32              pstate;
        nn::Bit64              stackTop;
        nn::Bit64              stackBottom;
        std::vector<nn::Bit64> stackTrace;
    };

private:
    nn::Bit32               version;
    nn::Bit64               exceptionCode;
    nn::Bit64               exceptionAddress;
    nn::Bit64               codeSpecificData;
    nn::Bit64               exceptionThreadId;
    std::vector<ThreadInfo> thread;
    std::vector<ModuleInfo> module;
};

}} // nn::creport
