﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Diagnostics;
using System.IO;
using System.Threading.Tasks;
using BezelEditor.Mvvm;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.NspEntriesWindow
{
    public class NspEntriesHelper : DisposableModelBase
    {
        private readonly INspFile _nspFile;

        public DisposableDirectory TempDir { get; }

        public NspEntriesHelper(INspFile nspFile)
        {
            _nspFile = nspFile;
            TempDir = new DisposableDirectory().AddTo(CompositeDisposable);
        }

        public void OpenByAssociationAppAsync(string extractedFilePath)
        {
            try
            {
                Process.Start(extractedFilePath);
            }
            catch
            {
                var p = new Process
                {
                    StartInfo =
                    {
                        FileName = "rundll32.exe",
                        Arguments = "shell32.dll,OpenAs_RunDLL " + extractedFilePath
                    }
                };
                p.Start();
            }
        }

        public async Task<string> ExtractEntryToTempDir(FileEntry fileEntry)
        {
            var extractedFilePath = Path.Combine(TempDir.RootPath, fileEntry.Name);
            await _nspFile.ExtractAsync(fileEntry.RawPath, extractedFilePath).ConfigureAwait(false);
            return extractedFilePath;
        }
    }
}
