﻿using System;
using System.IO;
using System.Reactive.Linq;
using BezelEditor.Foundation.Utilities;
using Nintendo.Authoring.AuthoringEditor.Properties;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class FilePathStringParamVm : ParamVm, IFilePathPropertyParamVm
    {
        public string Filter
            => _filterTag == null ? null : Resources.ResourceManager.GetString(_filterTag, Resources.Culture);

        public string Title
            => _titleTag == null ? null : Resources.ResourceManager.GetString(_titleTag, Resources.Culture);

        private readonly string _filterTag;
        private readonly string _titleTag;
        public bool IsSaveDialog { get; set; }

        //
        public ReactiveCommand<string> OpenByExplorerCommand { get; }

        public ReactiveProperty<string> FilePathProperty { get; }

        public FilePathStringParamVm(string captionTag, string commentTag, IReactiveProperty pathProperty,
            string filterTag,
            string titleTag,
            bool isSaveDialog,
            IObservable<string> absolutePathSource = null
        )
            : base(captionTag, commentTag, pathProperty)
        {
            _filterTag = filterTag;
            _titleTag = titleTag;
            IsSaveDialog = isSaveDialog;

            FilePathProperty = (ReactiveProperty<string>)pathProperty;
            var path = string.Empty;

            OpenByExplorerCommand = (absolutePathSource ?? FilePathProperty)
                .Select(x =>
                {
                    path = x;
                    if (string.IsNullOrEmpty(FilePathProperty.Value))
                        return false;
                    if (File.Exists(x))
                        return true;
                    if (Directory.Exists(x))
                        return true;
                    return false;
                })
                .ToReactiveCommand<string>()
                .AddTo(CompositeDisposable);

            OpenByExplorerCommand
                .Subscribe(_ =>
                {
                    if (File.Exists(path))
                        WindowsUtility.OpenFileByExplorer(path);
                    else if (Directory.Exists(path))
                        WindowsUtility.OpenFolderByExplorer(path);
                })
                .AddTo(CompositeDisposable);

            CultureService.Instance.ObserveProperty(x => x.Resources)
                .Subscribe(_ =>
                {
                    // ReSharper disable ExplicitCallerInfoArgument
                    RaisePropertyChanged(nameof(Filter));
                    // ReSharper restore ExplicitCallerInfoArgument
                })
                .AddTo(CompositeDisposable);
        }
    }

}
