﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Reactive.Linq;
using BezelEditor.Foundation.Extentions;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class CacheStorageSummaryParamVm : ParamVm
    {
        public ReadOnlyReactiveProperty<string> TotalSizeString { get; }

        public CacheStorageSummaryParamVm(string captionTag, string commentTag, ApplicationMeta appMeta)
            : base(captionTag, commentTag, null)
        {
            var app = appMeta.Application;

            TotalSizeString = Observable
                .Merge(app.ObserveProperty(x => x.CacheStorageSize).ToUnit())
                .Merge(app.ObserveProperty(x => x.CacheStorageJournalSize).ToUnit())
                .Select(x => app.TotalCacheStorageSize.ToReadableSizeString())
                .ToReadOnlyReactiveProperty()
                .AddTo(CompositeDisposable);
        }
    }
}
