﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Reactive.Bindings.Extensions;
using SimpleInjector;
using System;
using static Nintendo.Authoring.AuthoringEditor.Properties.Resources;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class AocContentsPageVm : PageVmBase
    {
        public AocContentsPageVm(Container diContainer, App app, Project project)
            : base(nameof(AocList))
        {
            var aocContents = new AocContentsParamVm(diContainer, app, project).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            Params = new ParamVm[]
            {
                aocContents
            };

            /////////////////////////////////////////////////////////
            project.AocMeta.ObserveProperty(x => x.HasErrors)
                .Subscribe(_ => HasErrors.Value = project.AocMeta.HasErrors)
                .AddTo(CompositeDisposable);
        }
    }
}
