﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Authoring.AuthoringEditor.Properties;
using Nintendo.Foundation.IO;

namespace Nintendo.Authoring.AuthoringEditor
{
    public class CommandLineParams
    {
        public static string HelpProjectPath => Resources.CommandLineParams_HelpProjectPath;
        public static string HelpMetaPath => Resources.CommandLineParams_HelpMetaPath;
        public static string HelpNspPath => Resources.CommandLineParams_HelpNspPath;
        public static string HelpNspdPath => Resources.CommandLineParams_HelpNspdPath;
        public static string HelpMode => Resources.CommandLineParams_HelpMode;
        public static string HelpInputFilePath => Resources.CommandLineParams_HelpInputFilePath;

        [CommandLineOption("project", DescriptionPropertyName = nameof(HelpProjectPath))]
        public string ProjectPath { get; set; }

        [CommandLineOption("meta", DescriptionPropertyName = nameof(HelpMetaPath), IsHidden = true)]
        public string MetaPath
        {
            get { return NintendoMetaPath; }
            set { NintendoMetaPath = value; }
        }

        [CommandLineOption("nmeta", DescriptionPropertyName = nameof(HelpMetaPath))]
        public string NintendoMetaPath { get; set; }

        [CommandLineOption("nsp", DescriptionPropertyName = nameof(HelpNspPath))]
        public string NspPath { get; set; }

        // TODO: nspd および mode へのサポートを入れる

        [CommandLineOption("nspd", DescriptionPropertyName = nameof(HelpNspPath), IsHidden = true)]
        public string NspdPath { get; set; }

        [CommandLineOption("mode", DescriptionPropertyName = nameof(HelpMode), IsHidden = true)]
        public string Mode { get; set; }

        [CommandLineValue(0, DescriptionPropertyName = nameof(HelpInputFilePath), IsRequired = false)]
        public string InputFilePath { get; set; }

        [CommandLineValue(1, DescriptionPropertyName = nameof(HelpInputFilePath), IsRequired = false)]
        public string InputOriginalNspFilePath { get; set; }
    }
}
