﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace Nintendo.Authoring.AuthoringEditor.Foundation
{
    public static class FileSystemHelper
    {
        // https://github.com/YoshihiroIto/ann/blob/master/Ann.Foundation/DirectoryHelper.cs を参考に実装しました。
        public static IEnumerable<string> EnumerateAllFiles(string path)
        {
            try
            {
                var dirFiles = Directory.EnumerateDirectories(path)
                    .SelectMany(EnumerateAllFiles);

                return dirFiles.Concat(Directory.EnumerateFiles(path));
            }
            catch
            {
                return Enumerable.Empty<string>();
            }
        }

        public static IEnumerable<string> EnumerateAllDirectories(string path)
        {
            try
            {
                var dirFiles = Directory.EnumerateDirectories(path)
                    .SelectMany(EnumerateAllDirectories);

                return dirFiles.Concat(Directory.EnumerateDirectories(path));
            }
            catch
            {
                return Enumerable.Empty<string>();
            }
        }

        public static bool IsEqualDirectory(string dirPath1, string dirPath2, Func<string, bool> matcher = null)
        {
            if (dirPath1 == null && dirPath2 == null)
                return true;

            if ((dirPath1 != null && dirPath2 != null) == false)
                return false;

            if (dirPath1.EndsWith("\\") == false)
                dirPath1 += "\\";

            if (dirPath2.EndsWith("\\") == false)
                dirPath2 += "\\";

            var dir1 = EnumerateAllFiles(dirPath1).Select(x => new FileInfo(x)).ToArray();
            var dir2 = EnumerateAllFiles(dirPath2).Select(x => new FileInfo(x)).ToArray();

            if (dir1.Length == 0 && dir2.Length != 0)
                return false;

            if (dir1.Length != 0 && dir2.Length == 0)
                return false;

            if (dir1.Length != dir2.Length)
                return false;

            if (dir1.Length == 0 && dir2.Length == 0)
                return true;

            var isNotEqual = dir1.Zip(dir2, Tuple.Create)
                .AsParallel()
                .Any(d =>
                {
                    if (d.Item1.Name != d.Item2.Name)
                        return true;

                    if (matcher != null)
                    {
                        var relativePath = d.Item1.FullName
                            .Substring(dirPath1.Length)
                            .Replace(Path.DirectorySeparatorChar, Path.AltDirectorySeparatorChar);
                        if (matcher(relativePath))
                            return false;
                    }

                    if (d.Item1.Length != d.Item2.Length)
                        return true;

                    return IsEqualFile(d.Item1.FullName, d.Item2.FullName) == false;
                });

            return isNotEqual == false;
        }

        public static bool IsEqualFile(string filePath1, string filePath2)
        {
            using (var s1 = new BufferedStream(File.OpenRead(filePath1), 1 * 1024 * 1024))
            using (var s2 = new BufferedStream(File.OpenRead(filePath2), 1 * 1024 * 1024))
            {
                if (StreamHelper.IsEqual(s1, s2) == false)
                    return false;
            }
            return true;
        }
    }
}
