﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Xml.Serialization;
using Nintendo.Authoring.AuthoringEditor.Foundation;

namespace Nintendo.Authoring.AuthoringEditor.Core
{
    public class UnpublishableError
    {
        public class MessageResource
        {
            public string Japanese { get; set; }
            public string English { get; set; }
        }

        public class ErrorMessage
        {
            public string Id { get; set; }
            public MessageResource Title { get; set; }
            public MessageResource Description { get; set; }
        }

        [XmlRoot("Content")]
        public class ErrorItem
        {
            public string Type { get; set; }
            public ErrorMessage Message { get; set; }
        }

        public class ErrorContent
        {
            [XmlIgnore]
            public ulong Id { get; set; }

            [XmlElement("Id")]
            public string IdHex
            {
                get { return Id.ToHex(); }
                set { Id = value.ToUlong(); }
            }

            public string Type { get; set; }

            [XmlElement("Error")]
            public List<ErrorItem> Errors { get; set; }
        }

        public ErrorContent Content { get; set; }

    }
}
