﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Xml.Serialization;

namespace Nintendo.Authoring.AuthoringEditor.Core.Serialization
{
    [Serializable]
    [XmlRoot("Meta")]
    public class AocMeta
    {
        [XmlElement("AddOnContent")]
        public AddOnContent[] AddOnContent { get; set; }
    }

    [Serializable]
    public class AddOnContent
    {
        public ulong Index { get; set; }
        public ulong ReleaseVersion { get; set; }
        public string ApplicationId { get; set; }
        public ulong RequiredApplicationReleaseVersion { get; set; }
        public ExpandablePath DataPath { get; set; }
        public string Tag { get; set; }
    }
}
