﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.ObjectModel;
using System.Xml.Serialization;
using BezelEditor.Foundation.Collections;
using BezelEditor.Mvvm;
using Nintendo.Authoring.AuthoringEditor.Foundation;

namespace Nintendo.Authoring.AuthoringEditor.Core
{
    public class Middleware : DisposableModelBase
    {
        #region ModuleName

        private string _ModuleName;

        public string ModuleName
        {
            get { return _ModuleName; }
            set { SetProperty(ref _ModuleName, value); }
        }

        #endregion

        #region VendorName

        private string _VendorName;

        [XmlElement("VenderName")]
        public string VendorName
        {
            get { return _VendorName; }
            set { SetProperty(ref _VendorName, value); }
        }

        #endregion

        #region NsoName

        private string _NsoName;

        public string NsoName
        {
            get { return _NsoName; }
            set { SetProperty(ref _NsoName, value); }
        }

        #endregion
    }

    public class ProgramInfo : DisposableModelBase
    {
        #region SdkVersion

        private string _SdkVersion;

        [XmlElement("SdkVersion")]
        public string RawSdkVersion
        {
            get { return _SdkVersion.Replace('.', '_'); }
            // ReSharper disable once ExplicitCallerInfoArgument
            set { SetProperty(ref _SdkVersion, value?.Replace('_', '.'), nameof(SdkVersion)); }
        }

        [XmlIgnore]
        public string SdkVersion
        {
            get { return _SdkVersion; }
            set { SetProperty(ref _SdkVersion, value); }
        }

        #endregion

        #region ToolVersion

        private string _ToolVersion;

        [XmlElement("ToolVersion")]
        public string RawToolVersion
        {
            get { return _ToolVersion.Replace('.', '_'); }
            // ReSharper disable once ExplicitCallerInfoArgument
            set { SetProperty(ref _ToolVersion, value?.Replace('_', '.'), nameof(ToolVersion)); }
        }

        [XmlIgnore]
        public string ToolVersion
        {
            get { return _ToolVersion; }
            set { SetProperty(ref _ToolVersion, value); }
        }

        #endregion

        #region BuildType

        private string _BuildType;

        public string BuildType
        {
            get { return _BuildType; }
            set { SetProperty(ref _BuildType, value); }
        }

        #endregion

        #region Middlewares

        private ObservableCollection<Middleware> _Middlewares = new ObservableCollection<Middleware>();

        [XmlArray("MiddlewareList")]
        [XmlArrayItem("Middleware")]
        public ObservableCollection<Middleware> Middlewares
        {
            get { return _Middlewares; }
            set { SetProperty(ref _Middlewares, value); }
        }

        #endregion

        #region PatchToolVersion

        private string _PatchToolVersion;

        [XmlElement("PatchToolVersion")]
        public string RawPatchToolVersion
        {
            get { return _PatchToolVersion.Replace('.', '_'); }
            // ReSharper disable once ExplicitCallerInfoArgument
            set { SetProperty(ref _PatchToolVersion, value?.Replace('_', '.'), nameof(PatchToolVersion)); }
        }

        [XmlIgnore]
        public string PatchToolVersion
        {
            get { return _PatchToolVersion; }
            set { SetProperty(ref _PatchToolVersion, value); }
        }

        #endregion

        #region FsAccessControlData

        private FsAccessControlData _FsAccessControlData = new FsAccessControlData();

        public FsAccessControlData FsAccessControlData
        {
            get { return _FsAccessControlData; }
            set { SetProperty(ref _FsAccessControlData, value); }
        }

        #endregion
    }
}
