﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using BezelEditor.Mvvm;
using Nintendo.Authoring.AuthoringEditor.Foundation;

namespace Nintendo.Authoring.AuthoringEditor.Core
{
    public class NspPatch : ViewModelBase
    {
        #region OriginalNspPath

        private string _OriginalNspPath;

        public string OriginalNspPath
        {
            get { return _OriginalNspPath; }
            set { SetProperty(ref _OriginalNspPath, value); }
        }

        #endregion

        #region CurrentNspPath

        private string _CurrentNspPath;

        public string CurrentNspPath
        {
            get { return _CurrentNspPath; }
            set { SetProperty(ref _CurrentNspPath, value); }
        }

        #endregion

        #region PreviousNspPath

        private string _PreviousNspPath;

        public string PreviousNspPath
        {
            get { return _PreviousNspPath; }
            set { SetProperty(ref _PreviousNspPath, value); }
        }

        #endregion

        #region IsUsePreviousNspPath

        private bool _IsUsePreviousNspPath;

        public bool IsUsePreviousNspPath
        {
            get { return _IsUsePreviousNspPath; }
            set { SetProperty(ref _IsUsePreviousNspPath, value); }
        }

        #endregion

        #region ApplicationDescPath

        private string _ApplicationDescPath = NintendoSdkHelper.ApplicationDescFilePath;

        public string ApplicationDescPath
        {
            get { return _ApplicationDescPath; }
            set { SetProperty(ref _ApplicationDescPath, value); }
        }

        #endregion

        #region OutputNspPath

        private string _OutputNspPath;

        public string OutputNspPath
        {
            get { return _OutputNspPath; }
            set { SetProperty(ref _OutputNspPath, value); }
        }

        #endregion
    }
}
