﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace Nintendo.AudioTool
{
    /// <summary>
    ///  キャプチャが行われた際に呼ばれるイベントハンドラの引数です。
    /// </summary>
    public class SystemAudioCaptureEventArgs : EventArgs
    {
        /// <summary>
        ///  コンストラクタです。
        /// </summary>
        public SystemAudioCaptureEventArgs(byte[] buffer, int bytes)
        {
            Buffer = buffer;
            BytesCaptured = bytes;
        }


        /// <summary>
        ///  キャプチャした波形のバッファです。
        /// </summary>
        public byte[] Buffer { get; }
        /// <summary>
        ///  キャプチャした波形のバイト数です。
        /// </summary>
        public int BytesCaptured { get; }
    }
}
