﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Runtime.InteropServices;

namespace Nintendo.Audio.Windows.CoreAudio.Interface
{
    [ComImport]
    [Guid(CoreAudioGuid.ISpatialAudioClientIdText)]
    [InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
    public interface ISpatialAudioClient
    {
        [PreserveSig]
        int GetStaticObjectPosition(AudioObjectType type, out float x, out float y, out float z);

        [PreserveSig]
        int GetNativeStaticObjectTypeMask(out AudioObjectType mask);

        [PreserveSig]
        int GetMaxDynamicObjectCount(out uint value);

        [PreserveSig]
        int GetSupportedAudioObjectFormatEnumerator(out IAudioFormatEnumerator enumerator);

        [PreserveSig]
        int GetMaxFrameCount(IntPtr objectFormat, out uint frameCountPerBuffer);

        [PreserveSig]
        int IsAudioObjectFormatSupported(IntPtr objectFormat);

        [PreserveSig]
        int IsSpatialAudioStreamAvailable(ref Guid streamUuid, [Optional] IntPtr auxiliaryInfo);

        [PreserveSig]
        int ActivateSpatialAudioStream(IntPtr activationParams, ref Guid riid, [MarshalAs(UnmanagedType.IUnknown)] out object stream);
    }
}
