﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>  // NOLINT(build/include_c_header)

typedef struct
{

    int32_t channels;           // Number of channels
    int32_t bitsPerSample;      // Number of bits per sample
    int32_t sampleRate;         // Sample rate in Hz
    int32_t samples;            // Number for samples
    int32_t loopStart;          // 1 based sample index for loop start
    int32_t loopEnd;            // 1 based sample count for loop samples
    int32_t bufferLength;       // buffer length in bytes

} SOUNDINFO;

enum SoundFileResult
{
    SoundFileResult_Success = 0,
    SoundFileResult_InvalidFormat = 1,
    SoundFileResult_OperationFailed = 2,
    SoundFileResult_FileCorrupted = 3
};
