﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

enum VoiceType
{
    VoiceType_OneShot = 0x0000,        // sample is not looped
    VoiceType_Looped = 0x0001          // sample is indeed looped
};

enum DecodeMode
{
    DecodeMode_Adpcm = 0x0000,         // ADPCM mode
    DecodeMode_Pcm16 = 0x000A,         // 16-bit PCM mode
    DecodeMode_Pcm8 = 0x0009           // 8-bit PCM mode (UNSIGNED)
};

typedef struct
{
    u32 num_samples;
    u32 num_adpcm_nibbles;
    u32 sample_rate;

    u16 loop_flag;
    u16 format;
    u32 sa;     // loop start address
    u32 ea;     // loop end address
    u32 ca;     // current address

    u16 coef[16];

    // start context
    u16 gain;
    u16 ps;
    u16 yn1;
    u16 yn2;

    // loop context
    u16 lps;
    u16 lyn1;
    u16 lyn2;

    u16 multi_ch_count; // Multi-channel count.  One through six channels can be specified.
    u16 block_frame_count; // Number of ADPCM frames (8 bytes per frame) in each interleaved channel block

    u16 pad[9];

} DSPADPCMHEADER;
