﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Macro.h>

#include "SettingsManager_RapidJson.h"

//!< ローカル通信の設定名か否かを表す値を返します。
bool IsSettingNameLdnSettings(const ::std::string& value) NN_NOEXCEPT;

//!< ローカル通信設定をエクスポートします。
bool ExportLdnSettings(Node* pNode) NN_NOEXCEPT;

//!< ローカル通信設定をインポートします。
bool ImportLdnSettings(const Node& node) NN_NOEXCEPT;
