﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <vector>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/erpt.h>
#include <nn/fs.h>
#include <nn/util/util_Optional.h>

namespace errors {

void BeginDumpOutputToFile(nn::fs::FileHandle fileHandle, int64_t fileOffset);
void EndDumpOutputToFile();

nn::Result DumpReportCore(nn::erpt::ReportId& reportId, const nn::erpt::ReportMetaData& reportMetaData, uint8_t* pReportData, size_t reportDataSize,
    nn::util::optional<std::vector<std::string>> categories = nullptr,
    bool useCategoriesToExclude = false,
    nn::util::optional<std::vector<std::string>> fields = nullptr,
    bool userFieldsToExclude = false);

nn::Result DumpReport(nn::erpt::ReportId& reportId, const nn::erpt::ReportMetaData& reportMetaData,
    nn::util::optional<std::vector<std::string>> categories = nullptr,
    bool useCategoriesToExclude = false,
    nn::util::optional<std::vector<std::string>> fields = nullptr,
    bool userFieldsToExclude = false);

}
