﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenuCommand_ValueValidators.h"

#include <nn/nn_Common.h>
#include <algorithm>
#include <cctype>
#include "DevMenuCommand_CommandImplUtility.h"

namespace nn { namespace devmenucommand {

namespace detail {

bool IsHex16String(const std::string& s) NN_NOEXCEPT
{
    switch (s.size())
    {
        case 1: return s == "0";
        case 18:
        {
            return true
                && s[0] == '0'
                && std::tolower(static_cast<unsigned char>(s[1])) == 'x'
                && std::all_of(s.begin() + 2, s.end(), [](unsigned char c) { return std::isxdigit(c); })
            ;
        }
        default: return false;
    }
}

} // detail

}}
