﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_ImageDirectory.h>

namespace album {

bool MountTargetStorage(nn::fs::ImageDirectoryId storage) NN_NOEXCEPT;
void UnmountTargetStorage() NN_NOEXCEPT;
bool MountHostDirectory(const char* path) NN_NOEXCEPT;
void UnmountHostDirectory() NN_NOEXCEPT;
nn::Result IsEmptyStorage(bool* pOutValue, const char* mountName) NN_NOEXCEPT;

}   // namespace
