﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/capsrv/capsrv_AlbumFileDateTime.h>
#include <nn/capsrv/capsrv_AlbumFileContents.h>

namespace album {

struct FilenameInfo
{
    nn::capsrv::AlbumFileDateTime time;
    nn::ncm::ApplicationId applicationId;
    nn::capsrv::AlbumFileContentsType contents;
};

bool TryParseDateTime(const char** pOutNext, nn::capsrv::AlbumFileDateTime* pOutValue, const char* str, ptrdiff_t strLength) NN_NOEXCEPT;
bool TryParseHexaByte(const char** pOutNext, char* pOutValue, const char* str, ptrdiff_t strLength) NN_NOEXCEPT;
bool TryParseFilename(FilenameInfo* pOutValue, const char* p, int length) NN_NOEXCEPT;

bool IsAlbumFilename(const char* name, size_t length) NN_NOEXCEPT;
bool IsExtraAlbumFile(const char* name) NN_NOEXCEPT;
bool IsRegularAlbumFile(const char* name) NN_NOEXCEPT;

}
