﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <map>
#include <nn/nn_Common.h>

class Option
{
public:
    // 1 コマンドあたりせいぜい 32 だろうという前提
    static const int TargetArgumentCountMax = 32;

    Option(int argc, char** argv);

    const char* GetCommand() const
    {
        return m_Command.c_str();
    }

    bool HasSubCommand() const
    {
        return !m_SubCommand.empty();
    }

    const char* GetSubCommand() const
    {
        return m_SubCommand.c_str();
    }

    const char* GetTarget() const
    {
        return GetTarget(0);
    }

    const char* GetTarget(int index) const
    {
        return m_Target[index].c_str();
    }

    bool HasTarget() const
    {
        return HasTarget(0);
    }

    bool HasTarget(int index) const
    {
        return m_Target[index].size() > 0;
    }

    int GetTargetCount() const
    {
        return m_TargetCount;
    }

    bool HasGlobalOption(const char* key) const;
    bool HasKey(const char* key) const;
    const char* GetValue(const char* key) const;

    const std::map<std::string, std::string>& GetMap() const
    {
        return m_Map;
    }

private:
    std::string m_Command;
    std::string m_SubCommand;
    std::string m_Target[TargetArgumentCountMax];
    std::map<std::string, std::string> m_Map;
    std::map<std::string, std::string> m_GlobalOptionMap;
    int m_TargetCount = 0;
};

