﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/manu/manu_Api.h>
#include <nn/result/result_HandlingUtility.h>

#include "CalWriter_Log.h"

class LogWriter final
{
    NN_DISALLOW_COPY(LogWriter);
    NN_DISALLOW_MOVE(LogWriter);

public :
    LogWriter() NN_NOEXCEPT;

    ~LogWriter() NN_NOEXCEPT;

    ::nn::Result Write(const char* string);

    ::nn::Result Write(const void *p, size_t size);

private :
    const char* LogPath = "C:\\CalWriterManu.log";
};

namespace
{
    LogWriter logWriter;
}

void LogWrite(const char* format, ...) NN_NOEXCEPT
{
    const size_t bufSize = 16 * 1024;
    static char buf[bufSize];

    std::va_list list;
    va_start(list, format);
    int size = std::vsnprintf(buf, bufSize, format, list);
    va_end(list);

    NN_ABORT_UNLESS_RESULT_SUCCESS(logWriter.Write(buf, size));
}

LogWriter::LogWriter() NN_NOEXCEPT
{
}

LogWriter::~LogWriter() NN_NOEXCEPT
{
}

::nn::Result LogWriter::Write(const char* string)
{
    size_t size = std::strlen(string);
    NN_LOG("%s",string);
    NN_RESULT_DO(this->Write(string, size));
    NN_RESULT_SUCCESS;
}

::nn::Result LogWriter::Write(const void *p, size_t size) NN_NOEXCEPT
{
    size_t outSize = 0;
    nn::manu::GetFileSize(&outSize, LogPath);
    NN_RESULT_DO(nn::manu::WriteToHost(p, size, LogPath, outSize, size));
    NN_RESULT_SUCCESS;
}
