﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/* 一般的なWi-Fi通信で使用する機能に関する、ものはこちらに記載 */
#include <nn/os.h>
#include <nn/wlan/wlan_MacAddress.h>
#include <nn/wlan/wlan_Ssid.h>
#include <nn/wlan/wlan_Types.h>
#include <nn/mbuf/mbuf_Definitions.h>
#include "wlan_WdrvStateDefinition.h"
#include "driver/wlan_Driver.h"

namespace nn { namespace wlan {

static const uint8_t ZeroMacAddr[MacAddress::MacAddressSize] = {0};

struct WlanMacAddressData {
    Bit8 addr[MacAddress::MacAddressSize];
};

struct WlanSsidInfo {
    uint32_t length;
    uint8_t ssid[32];
};

struct WlanBssInfo {
    WlanBssInfo*    NextItem;
    WlanBssInfo*    PrevItem;
    uint16_t     BeaconPeriod;

    Bit16        Capability;
    Bit8         NCapability;
    uint8_t      ControlChannel;

    int          RateCount;
    uint8_t      Rates[16];
    uint16_t     VhtRxMcsMap;
    uint16_t     VhtTxMcsMap;
    uint8_t      Flags;
    uint8_t      VhtCap;
    uint8_t      BasicMcs[16];
    uint16_t     VhtMcsMap;
    uint16_t     VhtMcsMapProp;
    uint16_t     VhtTxMcsMapProp;

    uint16_t     Channel;
    int16_t      Rssi;
    uint8_t      PhyNoise;
    uint16_t     Snr;

    int          IeLength;
    uint8_t*     IeData;
    uint8_t      Bssid[MacAddress::MacAddressSize];
    WlanSsidInfo SsidInfo;
//    Ssid         EssidInfo; /* 実態が作られたら調整する */
};

struct WlanLocalBssConfiguration {
    int16_t      channel;
    uint16_t     beaconInterval;
    bool         hiddenSsid;
};

struct WlanConnectinoParameters {
    Ssid             ssid;
    MacAddress       bssid;
    int16_t          channel;
    uint32_t         keepAliveTime;
    BeaconIndication beaconInd;
    Security         security;
};

enum WlanCommandId {
    WLAN_COMMAND_START            = 0,
    WLAN_INITIALIZE,
    WLAN_FINALIZE,
    WLAN_INITIALIZE_ON_SKIPBOOT,

    WLAN_CHANGE_STATE_READY       = 5,
    WLAN_CHANGE_STATE_INFRA,
    WLAN_CHANGE_STATE_LOCAL_AP,
    WLAN_CHANGE_STATE_LOCAL_STA,
    WLAN_CHANGE_STATE_LOCAL_SPECTATOR,

    WLAN_SET_IFUPDOWN             = 10,
    WLAN_GET_IFUPDOWN,
    WLAN_SET_EVENTMASK,
    WLAN_GET_EVENTMASK,
    WLAN_SET_APCONFIGRATION,
    WLAN_SET_STATICAES_MODE,
    WLAN_SET_STATICAES_KEY,
    WLAN_SET_KEEPALIVE,
    WLAN_SET_CLIENT_TIMEOUT,
    WLAN_SET_BEACONLOST_TIMEOUT,

    WLAN_SCAN_REQUEST             = 20,
    WLAN_SCANLIST_REQUEST,
    WLAN_CANCEL_SCAN,
    WLAN_SET_MACADDRESS,
    WLAN_GET_MACADDRESS,
    WLAN_EXECUTE_ACSD,

    WLAN_CREATE_AP                = 30,
    WLAN_DESTROY_AP,
    WLAN_JOIN_NETWORK_STA,
    WLAN_JOIN_NETWORK_STA_WITH_WPS,
    WLAN_JOIN_NETWORK_SPECTATOR,
    WLAN_CANCEL_JOIN_NETWORK,
    WLAN_DISASSOCIATE,
    WLAN_DEAUTHENTICATE,

    WLAN_ADD_IE                   = 40,
    WLAN_DELETE_IE,
    WLAN_ADD_MATCHING_DATA,
    WLAN_REMOVE_MATCHING_DATA,
    WLAN_SET_BEACON_ACTION_FRAME,
    WLAN_CANCEL_BEACON_ACTION_FRAME,
    WLAN_GET_RSSI,
    WLAN_SET_TSF_TIMER_EVENT,
    WLAN_SET_RX_CHAIN,
    WLAN_SET_MAX_ASSOC_NUM,
    WLAN_GET_FW_VER,

    WLAN_REQUEST_SLEEP,
    WLAN_REQUEST_WAKEUP,
    WLAN_GET_WAKEUP_REASON,
    WLAN_SET_WAKEUP_REASON,
    WLAN_ENABLE_WOWL_FEATURES,
    WLAN_GET_WOWL_WAKE_COUNT,
    WLAN_GET_WOWL_SLEEP_STATS,
    WLAN_CLEAR_WOWL_WAKE_COUNT,
    WLAN_CLEAR_WOWL_SLEEP_STATS,
    WLAN_SET_GTK_INFO,
    WLAN_CLEAR_GTK_INFO,

    WLAN_GET_STATE            = 128,
    WLAN_GET_STATE_BEFORE_SLEEP,

    WLAN_CHANGE_STATE_LOCAL_LCS_AP,
    WLAN_CHANGE_STATE_LOCAL_LCS_STA,
    WLAN_CHANGE_STATE_READY_FROM_LCS_AP,
    WLAN_CHANGE_STATE_READY_FROM_LCS_STA,
    WLAN_CHANGE_STATE_DETECT,

    WLAN_GET_CHANNEL_STATS,

    WLAN_PUT_ONE_SHOT_ACTION_FRAME,
    WLAN_START_PERIODIC_ACTION_FRAME,
    WLAN_CANCEL_PERIODIC_ACTION_FRAME,
    WLAN_REQUEST_SLEEP_FOR_ND,
    WLAN_REQUEST_WAKEUP_FOR_ND,
    WLAN_SET_DETECT_RECV_CONF,
    WLAN_CLEAR_DETECT_SA_TOTAL_RECV_CNT,

    WLAN_EMULATE_DRIVER_INIT_FAIL,

    WLAN_SET_MULTICAST_LIST,
//    WLAN_COMMAND_LAST             = 255,
};

enum WlanEventId {
    WLAN_EVENT_START              = 1,
    WLAN_EVENT_SCAN_INDICATION,
    WLAN_EVENT_SCAN_COMPLETE,

    WLAN_EVENT_CONNECTED,
    WLAN_EVENT_DISASSOCIATE,
    WLAN_EVENT_DISASSOCIATE_IND,
    WLAN_EVENT_DEAUTHENTICATE,
    WLAN_EVENT_DEAUTHENTICATE_IND,
    WLAN_EVENT_BMISS,
    WLAN_EVENT_ROAM,

    WLAN_EVENT_IF_UP,

    WLAN_WPA_NOTIFY_SUCCESS,
    WLAN_WPA_NOTIFY_FAIURE,
    WLAN_WPS_NOTIFY_FAIURE,
    WLAN_WPA_NOTIFY_GTK_SET,
    WLAN_WPA_NOTIFY_GTK_CLEAR,
    WLAN_WPA_NOTIFY_CONNECT_START,
    WLAN_WPA_NOTIFY_CONNECT_ABORT,

    WLAN_EVENT_LINKCHANGE
};

enum LinkChangeReason {
    LinkChangeReason_Up = 0,        // Link up
    LinkChangeReason_BcnLoss,       // Link down ビーコンロスト
    LinkChangeReason_Disassoc,      // Link down Disassoc受信
    LinkChangeReason_AssocRecFail,  // Link down Assoc再生成失敗
    LinkChangeReason_BsscfgDown,    // Link down BSS config がdown
};

struct WlanLinkInfo {
    LinkChangeReason reason;
    uint8_t  PeerAddr[nn::wlan::MacAddress::MacAddressSize];
};

/* 接続時の相手先情報
 * PeerAddrは以下。
 * Station: APのBssid
 * AP     : 接続された端末のMacAddress
 */
struct WlanConnectIndicate {
    bool     Result;
    uint8_t  PeerAddr[nn::wlan::MacAddress::MacAddressSize];
    uint16_t capability;
};

/* 切断フレームを受けた時の相手先情報と切断理由
 * または切断発行時の相手先情報と切断理由
 * PeerAddrは以下。
 * Station: 切断してきたAPのBssid (切断発行時はPeerAddrは使用しない)
 * AP     : 切断してきた端末のMacAddress or 切断先MacAddress
 */
struct WlanDisconnectInfo {
    uint16_t reason;  // 切断理由
    uint8_t  PeerAddr[nn::wlan::MacAddress::MacAddressSize];
};

struct WlanScanParameters
{
    uint32_t scanType;
    uint16_t channelList[nn::wlan::WirelessChannelsCountMax];
    uint8_t channelCount;
    int32_t channelScanTime;
    int32_t homeChannelTime;
    WlanSsidInfo ssidList[nn::wlan::ScanningSsidCountMax];
    uint8_t ssidCount;
    Bit8 bssid[6];
};

struct WlanIeContainer {
    WlanIeContainer* prev;
    WlanIeContainer* next;
    uint32_t index; // IEに割り振るindex値。0は使わない。
    uint32_t flag;  // どのManagement frameに追加するかのフラグ
    uint32_t length;
    Bit8 oui[3];
    Bit8 body[255];   // TODO 適切なサイズ分確保出来るようにする
};

struct WlanStates {
    WdrvMainState mainState;
    WdrvSubState  subState;
};

struct WlanClientStatusInfo {
    ClientStatus status[ConnectableClientsCountMax];
    Bit32 updatedIndexBitMap;
};

struct WlanMatchingDataInfo {
    uint32_t rxId;
    ReceivedDataMatchInfo* pInfo;
};

struct WlanStaticAesInfo {
    uint8_t keyMode;                                  // Unicast用:0, Broadcast用:1
    uint8_t peerMacAddr[MacAddress::MacAddressSize];  // 対象MACアドレス
    Bit8 key[16];                                     // 鍵本体
};

struct WlanActionFrameInfo {
    uint8_t macAddr[MacAddress::MacAddressSize];  // 送信元MACアドレス
    nn::mbuf::Mbuf* pMbuf; // ActionFrameデータ
};

struct WlanPeriodicActionFrameInfo {
    char*  pData;
    size_t size;
    uint32_t count;
    uint32_t interval;
    uint8_t bssid[MacAddress::MacAddressSize];
};

struct WlanOneShotActionFrameInfo {
    char*  pData;
    size_t size;
    uint32_t channel;
    uint32_t dwellTime;
    uint8_t dstMac[MacAddress::MacAddressSize];
    uint8_t bssid[MacAddress::MacAddressSize];
};

struct WlanTsfTimerValue {
    uint32_t high;
    uint32_t low;
};

struct WlanAllowedChannels {
    uint32_t count;  // The number of allowed channels
    int16_t channel[driver::ChannelCountMax];
};

static const uint8_t StaticAesKeyLength = 16;

struct WlanIoctlResult {
    char* pStr;
    size_t size;
};

struct WlanWpsParameters {
    WpsMethod method;
    char pin[WpsPinLength + 1];
};

struct WlanWowlSetupParams {
    MacAddress          dstMac;
    WlanIpv4Address     srcIp;
    WlanIpv4Address     dstIp;
    uint16_t            srcPort;
    uint16_t            dstPort;
    uint32_t            ackNum;
    uint16_t            windowSize;
};

// CoexにおけるBTとの送信許可設定です。
enum SimultaneousTxParam {
    SimultaneousTxParam_Default = 0,   // ドライバーのデフォルト設定
    SimultaneousTxParam_1Antenna,       // アンテナ1本時の設定
    SimultaneousTxParam_2Antenna,       // アンテナ2本時の設定
};

// アクセスカテゴリindex
enum AccessCategoryIndex {
    AccessCategoryIndex_BE = 0,
    AccessCategoryIndex_BK,
    AccessCategoryIndex_VI,
    AccessCategoryIndex_VO,
};

// アクセスカテゴリごとのCWmin/max値です。
static const int DEFAULT_AC_BE_CWMIN =  4;  // BestEffort デフォルトCWmin値
static const int DEFAULT_AC_BE_CWMAX = 10;  // BestEffort デフォルトCWmax値
static const int LCS_AC_BE_CWMIN     =  4;  // BestEffort LCS用CWmin値
static const int LCS_AC_BE_CWMAX     = 10;  // BestEffort LCS用CWmax値

// APとのキープアライブを行う間隔
static const int STA_KEEPALIVE_TIME = 180 * 1000; // (単位ms)

// ACI mitigation
enum AciMitigation {
    AciMitigation_Default = 0,
    AciMitigation_LocalNormal,
    AciMitigation_LocalLcs,
    AciMitigation_Detect,
};

struct WlanTotalChannelStats
{
    ChannelStats* stats;
    size_t length;
    uint32_t* count;
};

struct WlanAllowedMulticastList {
    uint8_t count;  // The number of allowed Multicast Addresses
    WlanMacAddressData addr[MulticastFilterCountMax];
};

// すれちがい通信で使用するホームチャンネル
static const uint32_t DetectHomeChannel = 1;

/***** NDHP(Neighbor Detection Header Protocol)関連 *****/
static const uint8_t DhpMajor = 1;  // Major version
static const uint8_t DhpMiner = 0;  // Miner version
static const uint8_t DhpCmdPeriodic = 0x01;
static const uint8_t DhpCmdOneShot = 0x02;
/******************************************************/

// すれちがいスリープ用パラメータ
struct WlanDetectSetupParams {
    DetectPeriodicAfCycle sleepParam;
    uint8_t actionFrame[DetectActionFramePayloadMax + 100];  // Action Frameデータ
    uint16_t length; // pDataのサイズ
    DetectHashList hashList;
    uint32_t cacheCntMax;  // FWで最大何個までActionFrameをキャッシュさせるか（1~8 or 0. 0の場合最大となる）
};

enum SleepMode {
    SleepMode_Normal = 0,
    SleepMode_Wowl,
    SleepMode_Detect
};

// すれちがいスリープ送受信パターン
static const uint32_t DetectSleepTxInterval = 127;  // 次の送信までの間隔(ms)
static const uint32_t DetectSleepTxCount = 30;      // 1周期に送信を何回行うか
static const uint32_t DetectSleepIdleCount = 0;    // 次の周期までに空ける間隔(txIntervalの倍数)
static const uint32_t DetectSleepRxStartCount = 0; // 受信開始タイミング(txIntervalの倍数)
static const uint32_t DetectSleepRxCount = 1;      // 1周期に受信を何回行うか

// すれちがいスリープFWキャッシュサイズ
static const uint32_t DetectCacheCnt = 7;  // (SIGLO-80387)

// ActoinFrame受信モード
// すれちがい通信機能の実現のために通常の受信仕様とは異なるモードが追加されている。
// 1. ユニークなBSSIDを持つActionFrameも受信出来る機能。
//    通常はBroadcastBSSIDと自分が参加しているネットワークBSSIDからのActionFrameしか受信出来ないが、
//    すれちがい通信では上記以外のBSSIDでActionFrameが飛んでくるので、そのようなBSSIDでも受信出来るモードが追加された。
// 2. 無線FW内でキャッシュしておく機能。
//    すれちがい通信をスリープ中でも行えるように、無線FWで受信したActoinFrameを一定個数キャッシュしておける機能が追加された。
//    この機能は基本、すれちがいスリープ中のみ使用される。
enum ActionFrameRecvMode {
    ActionFrameRecvMode_Normal = 0,    // 通常のActoinFrame受信モード
    ActionFrameRecvMode_DetectWake,    // 起床中すれちがいモード。上記機能の1.が使用される
    ActionFrameRecvMode_DetectSleep,   // スリープ中すれちがいモード。上記機能の1．と2．が使用される
    ActionFrameRecvMode_Num
};

struct WlanActionFrameRecvInfo {
    uint16_t channel;       // 受信したActionFrameの送信元チャンネル
    int32_t rssi;          // 受信したActionFrameのrssi
    int64_t sysTick;   // ActionFrameを受信したときのsys tick値(64bit値)
};

// すれちがいスリープに入る条件をどの程度満たしているか
enum DetectSleepCondition {
    DetectSleepCondition_Ok,          // 条件を満たしている
    DetectSleepCondition_NoData,      // 送信データがセットされていない
    DetectSleepCondition_NotReserved  // スリープ予約がされていない
};

}}
