﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/mbuf/mbuf_Definitions.h>
#include "wlan_CommonType.h"
#include "wlan_MezcalType.h"

namespace nn { namespace wlan {

class WlanBaseFunctions
{
public:
    WlanBaseFunctions() NN_NOEXCEPT
       : WlanFunctionsInitialized(false)
    {};

    virtual ~WlanBaseFunctions() NN_NOEXCEPT
    {
        WlanFunctionsInitialized = false;
    };

    virtual bool InitializeDriver() NN_NOEXCEPT = 0;
    virtual void FinalizeDriver() NN_NOEXCEPT = 0;

    virtual void InitializeEventmask(uint32_t mode) NN_NOEXCEPT = 0;

    virtual bool ChangeWirelessMode(uint32_t mode) NN_NOEXCEPT = 0;
    virtual void ResetParams() NN_NOEXCEPT = 0;

    virtual bool SetIfUpDown(uint32_t up_down) NN_NOEXCEPT = 0;
    virtual bool GetIfUpDown(uint32_t* up_down) NN_NOEXCEPT = 0;
    virtual bool SetEventMask(uint8_t pmask) NN_NOEXCEPT = 0;
    virtual bool ClearEventMask() NN_NOEXCEPT = 0;
    virtual bool GetEventMask(uint8_t* pmask) NN_NOEXCEPT = 0;
    virtual bool SetApConfigration(WlanLocalBssConfiguration* pbssinfo) NN_NOEXCEPT = 0;
    virtual bool CreateAp(WlanSsidInfo* pSsidInfo) NN_NOEXCEPT = 0;
    virtual bool DestroyAp() NN_NOEXCEPT = 0;
    virtual bool SetStaticAesMode(bool mode) NN_NOEXCEPT = 0;
    virtual bool SetStaticAesKey(WlanStaticAesInfo* pKeyInfo) NN_NOEXCEPT = 0;
    virtual bool SetClientTimeoutPeriod(uint32_t time) NN_NOEXCEPT = 0;
    virtual bool SetBeaconLostTimeout(int time) NN_NOEXCEPT = 0;
    virtual bool SetRxChain(int chain) NN_NOEXCEPT = 0;
    virtual bool SetTxChain(int chain) NN_NOEXCEPT = 0;
    virtual bool SetMaxAssociationNumber(int num) NN_NOEXCEPT = 0;
    virtual bool SetSimultaneousTx(SimultaneousTxParam param) NN_NOEXCEPT = 0;

    virtual bool ScanRequest(WlanScanParameters* scan_params) NN_NOEXCEPT = 0;
    virtual bool CancelScan() NN_NOEXCEPT = 0;

    virtual bool JoinNetworkSta(WlanConnectinoParameters* pssid) NN_NOEXCEPT = 0;
    virtual bool JoinNetworkSpectator(WlanConnectinoParameters* pssid) NN_NOEXCEPT = 0;
    virtual bool Disassociate() NN_NOEXCEPT = 0;
    virtual nn::Result Deauthenticate(WlanDisconnectInfo* deauthParam) NN_NOEXCEPT = 0;

    virtual bool SetMacAddress(const WlanMacAddressData* mac) NN_NOEXCEPT = 0;
    virtual bool GetMacAddress(uint8_t macAddress[MacAddress::MacAddressSize]) NN_NOEXCEPT = 0;
    virtual bool AddIe(uint32_t* pOutIndex, WlanIeContainer* pInIe) NN_NOEXCEPT = 0;
    virtual bool DeleteIe(uint32_t ieIndex) NN_NOEXCEPT = 0;
    virtual bool ExecuteAcsd() NN_NOEXCEPT = 0;
    virtual void SetAcsdFlag(bool var) NN_NOEXCEPT = 0;

    virtual bool GetChannel(int16_t* pOutChannel) NN_NOEXCEPT = 0;
    virtual bool GetAllowedChannels(WlanAllowedChannels* allowedChannel) NN_NOEXCEPT = 0;
    virtual void InitializeConnectionStatus() NN_NOEXCEPT = 0;
    virtual void GetConnectionStatus(ConnectionStatus* pOutStatus) NN_NOEXCEPT = 0;
    virtual bool UpdateClientStatus(const ClientStatus& status) NN_NOEXCEPT = 0;
    virtual void GetClientStatusList(ClientStatus* pOutList, uint8_t count, Bit32* pOutBitmap, bool IsClear = true) NN_NOEXCEPT = 0;
    virtual bool GetClientStatusByMac(ClientStatus* pOutStatus, const MacAddress& mac) NN_NOEXCEPT = 0;

    virtual nn::Result PutFrame(nn::mbuf::Mbuf* pMbuf) NN_NOEXCEPT = 0;
    virtual nn::Result PutActionFrameOneShot(const char* pData, uint16_t size,
            uint8_t dstMac[MacAddress::MacAddressSize], uint8_t bssid[MacAddress::MacAddressSize], uint32_t channel, uint32_t dwellTime) NN_NOEXCEPT = 0;
    virtual bool PutActionFramePeriodically(const char* pData, uint16_t size, uint8_t bssid[MacAddress::MacAddressSize],
            uint32_t count, uint32_t interval) NN_NOEXCEPT = 0;
    virtual bool CancelPutActionFramePeriodically() NN_NOEXCEPT = 0;

    virtual bool GetBeaconInterval(uint32_t* pOutInterval) NN_NOEXCEPT = 0;

    // Get RSSI
    virtual bool GetRssiForSta(int32_t* rssi) NN_NOEXCEPT = 0;

    // Enable/Disable TSF time event
    virtual bool SetTsfTimerEventmask(bool enable) NN_NOEXCEPT = 0;
    // Get TSF timer value
    virtual bool GetDeltaTimeBetweenSystemAndTsf(int64_t* pOutDeltaTime) NN_NOEXCEPT = 0;
    virtual bool GetFwVersion(WlanIoctlResult* pOutResult) NN_NOEXCEPT = 0;

    virtual bool IsMatchAssocList(uint8_t macAddr[MacAddress::MacAddressSize]) NN_NOEXCEPT = 0;

    virtual bool EnableCoexMc2() NN_NOEXCEPT = 0;
    virtual bool DisableCoexMc2() NN_NOEXCEPT = 0;
    virtual bool GetWakeupReasonRaw(uint32_t* pOutReason, WowlWakeCount* pCounts) NN_NOEXCEPT = 0;
    virtual WowlWakeReason ConvertWakeupReason(uint32_t reason) NN_NOEXCEPT = 0;
    virtual bool ClearWowlParams() NN_NOEXCEPT = 0;
    virtual bool SetupWowlParams(WlanWowlSetupParams* pParams) NN_NOEXCEPT = 0;
    virtual bool ActivateWowl() NN_NOEXCEPT = 0;
    virtual bool DisableWowl() NN_NOEXCEPT = 0;
    virtual bool SetDevicePowerState(bool isFullAwake) NN_NOEXCEPT = 0;
    virtual void SetWakeupReasonRaw(uint32_t reason) NN_NOEXCEPT = 0;
    virtual void EnableWowlFeatures(uint32_t features) NN_NOEXCEPT = 0;
    virtual void GetWowlSleepStats(WowlSleepStats* pStats) NN_NOEXCEPT = 0;
    virtual bool SetCwParam(AccessCategoryIndex accessCategory, int cwmin, int cwmax) NN_NOEXCEPT = 0;
    virtual void SetAciMitigation(AciMitigation id) NN_NOEXCEPT = 0;
    virtual bool GetChannelStats(ChannelStats* pStats, size_t length, uint32_t* pCount) NN_NOEXCEPT = 0;
    virtual void SetDetectHomeChannel(uint32_t channel) NN_NOEXCEPT = 0;
    virtual uint32_t GetDetectHomeChannel() NN_NOEXCEPT = 0;

    virtual bool PutActionFramePeriodicallyForDetect(const char* pData, uint16_t size, DetectPeriodicAfCycle pattern) NN_NOEXCEPT = 0;
    virtual bool SetupDetectSleepParams(WlanDetectSetupParams* pParams) NN_NOEXCEPT = 0;
    virtual bool ClearDetectSleepParams() NN_NOEXCEPT = 0;
    virtual bool ActivateDetectSleep() NN_NOEXCEPT = 0;
    virtual bool DisableDetectSleep() NN_NOEXCEPT = 0;
    virtual void PullActionFrameFromDongle() NN_NOEXCEPT = 0;
    virtual bool GetWakeupReasonRawDetectSleep(uint32_t* pOutReason, DetectWakeCount* pCounts) NN_NOEXCEPT = 0;
    virtual DetectWakeReason ConvertWakeupReasonDetectSleep(uint32_t reason) NN_NOEXCEPT = 0;
    virtual void ClearAfCache() NN_NOEXCEPT = 0;

    virtual void SetActionFrameRecvMode(ActionFrameRecvMode mode) NN_NOEXCEPT = 0;
    virtual uint64_t GetDetectSaTotalRecvCnt() NN_NOEXCEPT = 0;
    virtual void ClearDetectSaTotalRecvCnt() NN_NOEXCEPT = 0;

    virtual int GetConnectedClientCount() NN_NOEXCEPT = 0;

    static int EventCallBackFromDriver(void *buf);
    static int RxCallBackFromDriver(void *buf);
    static int TxCompletionCallBackFromDriver(void *buf, int result);

    virtual bool SetStaKeepAlive(int intervalms) NN_NOEXCEPT = 0;

    virtual void DisableFixedDesense() NN_NOEXCEPT = 0;

    virtual void SetMulticastList(WlanAllowedMulticastList* pList) NN_NOEXCEPT = 0;

public:
    // モードを表す定数
    static const uint32_t WlanModeInfraSta       =  1 << 0;
    static const uint32_t WlanModeLocalAp        =  1 << 1;
    static const uint32_t WlanModeLocalClient    =  1 << 2;
    static const uint32_t WlanModeLocalSpectator =  1 << 3;
    static const uint32_t WlanModeLocalLcsAp     =  1 << 4;
    static const uint32_t WlanModeLocalLcsClient =  1 << 5;
    static const uint32_t WlanModeDetect         =  1 << 6;


protected:
//    virtual bool ParseWlanNetworkInfo() = 0;

protected:
    bool              WlanFunctionsInitialized;
};

}}


