﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

typedef uint8_t uint8;
typedef uint32_t uint32;
#include <bwl.h>


namespace nn {
namespace wlan {

enum class Command : uint32_t
{
    INITIALIZE,
    FINALIZE,
    SET_STA_MODE,
    SET_LOCAL_AP_MODE,
    SET_LOCAL_STA_MODE,
    SET_CLOSE_MODE,

    SCAN,
    SCAN_COMPLETE_EVENT,
    SCAN_ABORT,

    CONNECT,
    CONNECTED_EVENT,
    DISCONNECT,
    DEAUTH,

    TEST_COMMAND_TEST0 = 0x100,
    TEST_COMMAND_TEST1,
    TEST_COMMAND_TEST2,
    TEST_COMMAND_TEST3,
    TEST_COMMAND_TEST4,
    TEST_COMMAND_TEST5,
    TEST_COMMAND_TEST6,
    TEST_COMMAND_TEST7,
    TEST_COMMAND_TEST8,
    TEST_COMMAND_TEST9,

    TEST_COMMAND_EXIT
};

/*
    association status (succeeded/failed)
    deauthenticated
    disassociated
    beacons lost
    beacon received
    scan complete
    interface created/modified/destroyed

    WLC_E_SET_SSID
    WLC_E_JOIN
    WLC_E_AUTH
    WLC_E_AUTH_IND
    WLC_E_ASSOC
    WLC_E_ASSOC_IND
    WLC_E_DEAUTH
    WLC_E_DEAUTH_IND
    WLC_E_LINK
    WLC_E_IF
    WLC_E_ACTION_FRAME
    WLC_E_ACTION_FRAME_COMPLETE
    WLC_E_ACTION_FRAME_RX
    WLC_E_AP_STARTED
    WLC_E_ESCAN_RESULT
*/
enum WlanEventType
{
    ASSOCIATE_SUCCEEDED,
    ASSOCIATE_FAILED,
    DEAUTHENTICATED,
    DISASSOCIATED,
    BEACON_LOST,
    SCAN_COMPLETE,
    INTERFACE_CREATED,
    INTERFACE_MODIFIED,
    INTERFACE_DESTROYED,

    BEACON_RECEIVED,

    EVENT_TYPE_MAX
};

struct WlanCommand
{
    uint32_t id;
    Command command;
    uint8_t arg[32];    // コマンド引数
};

struct WlanEvent
{
    uint32_t id;
    WlanEventType event;
};


enum WlanState
{
    STATE_STOP,
    STATE_READY,
    STATE_INFRA_STA_IDLE,
    STATE_INFRA_STA,
    STATE_LOCAL_CLIENT_IDLE,
    STATE_LOCAL_CLIENT,
    STATE_LOCAL_MASTER_IDLE,
    STATE_LOCAL_MASTER,

    STATE_TEST1,
    STATE_TEST_AP_IDLE,
    STATE_TEST_AP_CLASS1,
    STATE_TEST_AP_CLASS3,
    STATE_TEST_STA_IDLE,
    STATE_TEST_STA_CLASS1,
    STATE_TEST_STA_CLASS3,

    STATE_END
};



}
}

