﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "wlan_TestMacro.h"


namespace nn {
namespace wlan {

class Test
{
public:
    Test(){};
    ~Test(){};

    void Param();

    void Initialize();
    void Deinitialize();

    static void BinaryDump(void* data, int len, int type);

    void ScanTest();
    void StaTest();

    void Ap_Idle();
    void Ap_Class1();
    void Ap_Class3();
    void Sta_Idle();
    void Sta_Class1();
    void Sta_Class3();

    void ToIdle();
    void ToClass1();
    void ToApClass3();


    static int CbFunc_txcompletion(void *buf, int result);
    static int CbFunc_rxdata(void *buf);
    void EventRxCallback();
    static int CbFunc_rxevent(void *_event, void *buf);

    static void dump_bss_info(void *bi);
};


}
}

