﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/mbuf/mbuf_Mbuf.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>

//#include <netinet/ether.h>
#include "wlan_Type.h"
#include "wlan_Test.h"
#include <dhd_horizon.h>
#include <bwl.h>
//#include <wlioctl.h>

//#include <proto/bcmevent.h>
//#include <proto/802.11.h>
//#include <proto/ethernet.h>
//#include <bcmutils.h>
//#include <wlu_utils.h>

#include <cstdio>
#include <cstdint>
#include <cstring>
#include <cstdbool>
#include <cwctype>
namespace
{
    void * ifh;
    static uint8_t TEST_SSID[] = "TEST_SSID";
    static int      SIZEOF_TEST_SSID = 9;

    static const char *bcmerrorstrtable[] = BCMERRSTRINGTABLE;
    nn::os::EventType event;

}

#define TEST_ENTER()    NN_LOG(">>>> Enter %s <<<<\n", __FUNCTION__)
#define TEST_LEAVE()    NN_LOG("    <<<< Leave %s <<<<\n", __FUNCTION__)

namespace nn {
namespace wlan {

void Test::Param()
{
}

void Test::Initialize()
{
TEST_ENTER();
    nn::os::InitializeEvent( &event, false, nn::os::EventClearMode_AutoClear );
    bwl_dhd_initialize(&ifh);
TEST_LEAVE();
}

void Test::Deinitialize()
{
TEST_ENTER();
    bwl_dhd_deinitialize(ifh);
    nn::os::FinalizeEvent( &event );
TEST_LEAVE();
}

void Test::BinaryDump(void* data, int len, int type)
{
    int i, j;

    // TODO: const u8* pData に変更する
    char* pData = static_cast<char*>(data);

    NN_LOG("\n%s Len[%d]----------\n", __FUNCTION__, len);

    for (i = 0; i < len; i++)
    {
        char charprint[16];
        NN_LOG(" %02x", pData[i]);
        if (type == 1 && i % 16 == 7)
        {
            // スペース追加
            NN_LOG(" ");
        }
        charprint[i % 16] = pData[i];
        if (i % 16 == 15)
        {
            NN_LOG(" ");
            for (j = 0; j < sizeof(charprint); j++)
            {
                if (j % 8 == 0)
                {
                    // 8文字でスペース
                    NN_LOG(" ");
                }
                if (type == 1)
                {
                    // char 表示
                    if (iswprint(charprint[j]))
                    {
                        NN_LOG("%c", charprint[j]);
                    }
                    else
                    {
                        // 表示できないときは"."
                        NN_LOG(".");
                    }
                }
            }
            NN_LOG("\n");
        }
    }
    NN_LOG("\n----------\n");

}

void Test::ToIdle()
{
    PRINT_ERROR_IF_FAILED(bwl_down(ifh));
}

void Test::ToClass1()
{
    PRINT_ERROR_IF_FAILED(bwl_down(ifh));
    PRINT_ERROR_IF_FAILED(bwl_up(ifh));
}

void Test::ToApClass3()
{
    PRINT_ERROR_IF_FAILED(bwl_down(ifh));
    PRINT_ERROR_IF_FAILED(bwl_up(ifh));
    PRINT_ERROR_IF_FAILED(bwl_set_apmode(ifh, 1));
    PRINT_ERROR_IF_FAILED(bwl_set_channel(ifh, 11));
    PRINT_ERROR_IF_FAILED(bwl_create(ifh, TEST_SSID, sizeof(TEST_SSID)));
}

void Test::ScanTest()
{
    TEST_ENTER();
    /*
    // bwl_set_apmode -> STA
    PRINT_ERROR_IF_FAILED(bwl_set_apmode(ifh, 0));

        // bwl_get_apmode
        {
            int apmode;
            PRINT_ERROR_IF_FAILED(bwl_get_apmode(ifh, &apmode));
            if(apmode != 0)
            {
                PRINT_ERROR();
            }
        }
    */
    // bwl_set_inframode -> INFRA
    PRINT_ERROR_IF_FAILED(bwl_set_inframode(ifh, 1));

        // bwl_get_inframode
        {
            uint32_t inframode;
            PRINT_ERROR_IF_FAILED(bwl_get_inframode(ifh, &inframode));
            if(inframode != 1)
            {
                PRINT_ERROR();
            }
        }

    // bwl_up
    PRINT_ERROR_IF_FAILED(bwl_up(ifh));

        // bwl_isup
        {
            uint32_t isup = 0;
            PRINT_ERROR_IF_FAILED(bwl_isup(ifh, &isup));
            if(!isup)
            {
                PRINT_ERROR();
            }
        }

    EventRxCallback();

    PRINT_ERROR_IF_FAILED(bwl_advscan(ifh, NULL, 0, NULL, 0, -1, -1, -1,-1, 0, NULL ));

    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(50000) );


    TEST_LEAVE();
}

void Test::StaTest()
{
    TEST_ENTER();
#if 0 /* not used refer to wlan_TestTxRx.cpp */

    EventRxCallback();

    // bwl_set_apmode -> STA
    PRINT_ERROR_IF_FAILED(bwl_set_apmode(ifh, 0));

        // bwl_get_apmode
        {
            int apmode;
            PRINT_ERROR_IF_FAILED(bwl_get_apmode(ifh, &apmode));
            if(apmode != 0)
            {
                PRINT_ERROR();
            }
        }

    // bwl_set_inframode -> INFRA
    PRINT_ERROR_IF_FAILED(bwl_set_inframode(ifh, 1));

        // bwl_get_inframode
        {
            uint32_t inframode;
            PRINT_ERROR_IF_FAILED(bwl_get_inframode(ifh, &inframode));
            if(inframode != 1)
            {
                PRINT_ERROR();
            }
        }

    // bwl_up
    PRINT_ERROR_IF_FAILED(bwl_up(ifh));

        // bwl_isup
        {
            uint32_t isup = 0;
            PRINT_ERROR_IF_FAILED(bwl_isup(ifh, &isup));
            if(!isup)
            {
                PRINT_ERROR();
            }
        }


    PRINT_ERROR_IF_FAILED(bwl_join(ifh, TEST_SSID, SIZEOF_TEST_SSID));
#endif
    TEST_LEAVE();
}


void Test::Ap_Idle()
{
TEST_ENTER();
    // -------------------------------------------------------------------
    // bwl_up
    PRINT_ERROR_IF_FAILED(bwl_up(ifh));

        // bwl_isup
        {
            uint32_t isup = 0;
            PRINT_ERROR_IF_FAILED(bwl_isup(ifh, &isup));
            if(!isup)
            {
                PRINT_ERROR();
            }
        }

    // bwl_down
    PRINT_ERROR_IF_FAILED(bwl_down(ifh));

        // bwl_isup
        {
            uint32_t isup = 0;
            PRINT_ERROR_IF_FAILED(bwl_isup(ifh, &isup));
            if(isup)
            {
                PRINT_ERROR();
            }
        }


    // -------------------------------------------------------------------
    // bwl_set_apmode -> STA
    PRINT_ERROR_IF_FAILED(bwl_set_apmode(ifh, 0));

        // bwl_get_apmode
        {
            int apmode;
            PRINT_ERROR_IF_FAILED(bwl_get_apmode(ifh, &apmode));
            if(apmode != 0)
            {
                PRINT_ERROR();
            }
        }

    // bwl_set_apmode -> AP
    PRINT_ERROR_IF_FAILED(bwl_set_apmode(ifh, 1));

        // bwl_get_apmode
        {
            int apmode;
            PRINT_ERROR_IF_FAILED(bwl_get_apmode(ifh, &apmode));
            if(apmode != 1)
            {
                PRINT_ERROR();
            }
        }


    // -------------------------------------------------------------------
    // bwl_set_inframode -> IBSS
    PRINT_ERROR_IF_FAILED(bwl_set_inframode(ifh, 0));

        // bwl_get_inframode
        {
            uint32_t inframode;
            PRINT_ERROR_IF_FAILED(bwl_get_inframode(ifh, &inframode));
            if(inframode != 0)
            {
                PRINT_ERROR();
            }
        }

    // bwl_set_inframode -> INFRA
    PRINT_ERROR_IF_FAILED(bwl_set_inframode(ifh, 1));

        // bwl_get_inframode
        {
            uint32_t inframode;
            PRINT_ERROR_IF_FAILED(bwl_get_inframode(ifh, &inframode));
            if(inframode != 1)
            {
                PRINT_ERROR();
            }
        }

    // bwl_set_channel -> 11
    PRINT_ERROR_IF_FAILED(bwl_set_channel(ifh, 11));

        // bwl_get_channel
        {
            uint32_t channel;
            PRINT_ERROR_IF_FAILED(bwl_get_channel(ifh, &channel));
            if(channel != 11)
            {
                PRINT_ERROR();
            }
        }
#if 0 /* not used */
    // -------------------------------------------------------------------
    // bwl_join
    PRINT_ERROR_IF_SUCCESS(bwl_join(ifh, TEST_SSID, sizeof(TEST_SSID)));
#endif
    // bwl_create
    PRINT_ERROR_IF_SUCCESS(bwl_create(ifh, TEST_SSID, sizeof(TEST_SSID)));


    // -------------------------------------------------------------------
    struct ether_addr ether_bcast = {{255, 255, 255, 255, 255, 255}};
    // bwl_disassoc
    PRINT_ERROR_IF_SUCCESS(bwl_disassoc(ifh));

    // bwl_deauth
    PRINT_ERROR_IF_SUCCESS(bwl_deauth(ifh, &ether_bcast, DOT11_BSSTRANS_REASON_DEAUTH_RX));


    // -------------------------------------------------------------------
    // bwl_send_periodic_af
    //  int32_t bwl_send_periodic_af(void *ifh, uint8_t *data, uint16_t length,
    //          struct ether_addr *bssid, struct ether_addr *destmac,
    //          uint32_t count, uint32_t interval);
    {
        uint8_t data[] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff};
        uint16_t length = 16;
        struct ether_addr bssid = {{0x00, 0x11, 0x22, 0x33, 0x44, 0x55 }};
        struct ether_addr destmac = {{255, 255, 255, 255, 255, 255}};

        PRINT_ERROR_IF_SUCCESS(bwl_send_periodic_af(ifh, data, length, &bssid, &destmac, 10, 100));
    }

    // bwl_cancel_periodic_af
    PRINT_ERROR_IF_SUCCESS(bwl_cancel_periodic_af(ifh));

    // bwl_send_one_af
    //  int32_t bwl_send_one_af(void *ifh, uint8_t *data, uint16_t length,
    //          struct ether_addr *bssid, struct ether_addr *destmac,
    //          uint32_t channel, uint32_t dwell);
    {
        uint8_t data[] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff};
        uint16_t length = 16;
        struct ether_addr bssid = {{0x00, 0x11, 0x22, 0x33, 0x44, 0x55 }};
        struct ether_addr destmac = {{255, 255, 255, 255, 255, 255}};

        PRINT_ERROR_IF_SUCCESS(bwl_send_one_af(ifh, data, length, &bssid, &destmac, 11, 100));
    }

    // -------------------------------------------------------------------
    // bwl_add_afsubtype
    uint8_t subtypes[8] = {0, 1, 2, 3, 127, 128, 254, 255};
    for(int i = 0; i<8; i++)
    {
        PRINT_ERROR_IF_FAILED(bwl_add_afsubtype(ifh, subtypes[i]));
    }

    // bwl_get_afsubtypelist
    uint8_t subtypesbuf[8];
    PRINT_ERROR_IF_FAILED(bwl_get_afsubtypelist(ifh, subtypesbuf, 8));
    if(memcmp(subtypes, subtypesbuf, 8) != 0)
    {
        PRINT_ERROR();
    }

    // bwl_clear_afsubtypes
    uint8_t subtypeszero[8] = {0};
    PRINT_ERROR_IF_FAILED(bwl_clear_afsubtypes(ifh));
        PRINT_ERROR_IF_FAILED(bwl_get_afsubtypelist(ifh, subtypesbuf, 8));
        if(memcmp(subtypeszero, subtypesbuf, 8) != 0)
        {
            PRINT_ERROR();
        }


    // -------------------------------------------------------------------
    // bwl_set_ds3mode
    PRINT_ERROR_IF_FAILED(bwl_set_ds3mode(ifh, 1));

    // bwl_get_ds3mode
    {
        uint32_t mode;
        PRINT_ERROR_IF_FAILED(bwl_get_ds3mode(ifh, &mode));
        if(mode != 1)
        {
            PRINT_ERROR();
        }
    }

    // -------------------------------------------------------------------
    // bwl_set_bcnlossthresh
    PRINT_ERROR_IF_FAILED(bwl_set_bcnlossthresh(ifh, 10));

    // bwl_get_bcnlossthresh
    {
        uint32_t bcnlossthresh;
        PRINT_ERROR_IF_FAILED(bwl_get_bcnlossthresh(ifh, &bcnlossthresh));
        if(bcnlossthresh != 10)
        {
            PRINT_ERROR();
        }
    }

TEST_LEAVE();
} //NOLINT(impl/function_size)

void Test::Ap_Class1()
{
TEST_ENTER();
    // -------------------------------------------------------------------
    // bwl_up
    PRINT_ERROR_IF_FAILED(bwl_up(ifh));

        // bwl_isup
        {
            uint32_t isup;
            PRINT_ERROR_IF_FAILED(bwl_isup(ifh, &isup));
            if(!isup)
            {
                PRINT_ERROR();
            }
        }

    // bwl_down
    PRINT_ERROR_IF_FAILED(bwl_down(ifh));

        // bwl_isup
        {
            uint32_t isup;
            PRINT_ERROR_IF_FAILED(bwl_isup(ifh, &isup));
            if(isup)
            {
                PRINT_ERROR();
            }
        }

    // -------------------------------------------------------------------
    // To CLASS1
    PRINT_ERROR_IF_FAILED(bwl_up(ifh));
    // -------------------------------------------------------------------

    // bwl_set_apmode -> STA
    PRINT_ERROR_IF_FAILED(bwl_set_apmode(ifh, 0));

        // bwl_get_apmode
        {
            int apmode;
            PRINT_ERROR_IF_FAILED(bwl_get_apmode(ifh, &apmode));
            if(apmode != 0)
            {
                PRINT_ERROR();
            }
        }

    // bwl_set_apmode -> AP
    PRINT_ERROR_IF_FAILED(bwl_set_apmode(ifh, 1));

        // bwl_get_apmode
        {
            int apmode;
            PRINT_ERROR_IF_FAILED(bwl_get_apmode(ifh, &apmode));
            if(apmode != 1)
            {
                PRINT_ERROR();
            }
        }


    // -------------------------------------------------------------------
    // bwl_set_inframode -> IBSS
    PRINT_ERROR_IF_FAILED(bwl_set_inframode(ifh, 0));

        // bwl_get_inframode
        {
            uint32_t inframode;
            PRINT_ERROR_IF_FAILED(bwl_get_inframode(ifh, &inframode));
            if(inframode != 0)
            {
                PRINT_ERROR();
            }
        }

    // bwl_set_inframode -> INFRA
    PRINT_ERROR_IF_FAILED(bwl_set_inframode(ifh, 1));

        // bwl_get_inframode
        {
            uint32_t inframode;
            PRINT_ERROR_IF_FAILED(bwl_get_inframode(ifh, &inframode));
            if(inframode != 1)
            {
                PRINT_ERROR();
            }
        }

    // bwl_set_channel -> 11 -> Fail
    PRINT_ERROR_IF_SUCCESS(bwl_set_channel(ifh, 11));

    // -------------------------------------------------------------------
    // CLASS3 To CLASS1
    ToClass1();
    // -------------------------------------------------------------------


    // -------------------------------------------------------------------
    /*
    // bwl_join
    uint8_t ssid[] = "SSID";
    PRINT_ERROR_IF_SUCCESS(bwl_join(ifh, ssid, sizeof(ssid)));
    */

    // bwl_create
    PRINT_ERROR_IF_FAILED(bwl_create(ifh, TEST_SSID, sizeof(TEST_SSID)));


    // -------------------------------------------------------------------
    struct ether_addr ether_bcast = {{255, 255, 255, 255, 255, 255}};
    // bwl_disassoc
    PRINT_ERROR_IF_SUCCESS(bwl_disassoc(ifh));

    // bwl_deauth
    PRINT_ERROR_IF_SUCCESS(bwl_deauth(ifh, &ether_bcast, DOT11_RC_DEAUTH_LEAVING));


    // -------------------------------------------------------------------
    // bwl_send_periodic_af
    //  int32_t bwl_send_periodic_af(void *ifh, uint8_t *data, uint16_t length,
    //          struct ether_addr *bssid, struct ether_addr *destmac,
    //          uint32_t count, uint32_t interval);
    {
        uint8_t data[] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff};
        uint16_t length = 16;
        struct ether_addr bssid = {{0x00, 0x11, 0x22, 0x33, 0x44, 0x55 }};
        struct ether_addr destmac = {{255, 255, 255, 255, 255, 255}};

        PRINT_ERROR_IF_SUCCESS(bwl_send_periodic_af(ifh, data, length, &bssid, &destmac, 10, 100));
    }

    // bwl_cancel_periodic_af
    PRINT_ERROR_IF_SUCCESS(bwl_cancel_periodic_af(ifh));

    // bwl_send_one_af
    //  int32_t bwl_send_one_af(void *ifh, uint8_t *data, uint16_t length,
    //          struct ether_addr *bssid, struct ether_addr *destmac,
    //          uint32_t channel, uint32_t dwell);
    {
        uint8_t data[] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff};
        uint16_t length = 16;
        struct ether_addr bssid = {{0x00, 0x11, 0x22, 0x33, 0x44, 0x55 }};
        struct ether_addr destmac = {{255, 255, 255, 255, 255, 255}};

        PRINT_ERROR_IF_SUCCESS(bwl_send_one_af(ifh, data, length, &bssid, &destmac, 11, 100));
    }

    // -------------------------------------------------------------------
    // bwl_add_afsubtype
    uint8_t subtypes[8] = {0, 1, 2, 3, 127, 128, 254, 255};
    for(int i = 0; i<8; i++)
    {
        PRINT_ERROR_IF_FAILED(bwl_add_afsubtype(ifh, subtypes[i]));
    }

    // bwl_get_afsubtypelist
    uint8_t subtypesbuf[8];
    PRINT_ERROR_IF_FAILED(bwl_get_afsubtypelist(ifh, subtypesbuf, 8));
    if(memcmp(subtypes, subtypesbuf, 8) != 0)
    {
        PRINT_ERROR();
    }

    // bwl_clear_afsubtypes
    uint8_t subtypeszero[8] = {0};
    PRINT_ERROR_IF_FAILED(bwl_clear_afsubtypes(ifh));
        PRINT_ERROR_IF_FAILED(bwl_get_afsubtypelist(ifh, subtypesbuf, 8));
        if(memcmp(subtypeszero, subtypesbuf, 8) != 0)
        {
            PRINT_ERROR();
        }


    // -------------------------------------------------------------------
    // bwl_set_ds3mode
    PRINT_ERROR_IF_FAILED(bwl_set_ds3mode(ifh, 1));

    // bwl_get_ds3mode
    {
        uint32_t mode;
        PRINT_ERROR_IF_FAILED(bwl_get_ds3mode(ifh, &mode));
        if(mode != 1)
        {
            PRINT_ERROR();
        }
    }

    // -------------------------------------------------------------------
    // bwl_set_bcnlossthresh
    PRINT_ERROR_IF_FAILED(bwl_set_bcnlossthresh(ifh, 10));

    // bwl_get_bcnlossthresh
    {
        uint32_t bcnlossthresh;
        PRINT_ERROR_IF_FAILED(bwl_get_bcnlossthresh(ifh, &bcnlossthresh));
        if(bcnlossthresh != 10)
        {
            PRINT_ERROR();
        }
    }

TEST_LEAVE();
} //NOLINT(impl/function_size)

void Test::Ap_Class3()
{
TEST_ENTER();
    // -------------------------------------------------------------------
    // CLASS3
    ToApClass3();

    // -------------------------------------------------------------------
    // bwl_up
    PRINT_ERROR_IF_FAILED(bwl_up(ifh));

        // bwl_isup
        {
            uint32_t isup;
            PRINT_ERROR_IF_FAILED(bwl_isup(ifh, &isup));
            if(!isup)
            {
                PRINT_ERROR();
            }
        }

    // bwl_down
    PRINT_ERROR_IF_FAILED(bwl_down(ifh));

        // bwl_isup
        {
            uint32_t isup;
            PRINT_ERROR_IF_FAILED(bwl_isup(ifh, &isup));
            if(isup)
            {
                PRINT_ERROR();
            }
        }

    // -------------------------------------------------------------------
    // CLASS3
    ToApClass3();

    // bwl_set_apmode -> STA
    PRINT_ERROR_IF_SUCCESS(bwl_set_apmode(ifh, 0));

    // bwl_set_apmode -> AP
    PRINT_ERROR_IF_SUCCESS(bwl_set_apmode(ifh, 1));


    // -------------------------------------------------------------------
    // bwl_set_inframode -> IBSS
    PRINT_ERROR_IF_SUCCESS(bwl_set_inframode(ifh, 0));

    // bwl_set_inframode -> INFRA
    PRINT_ERROR_IF_SUCCESS(bwl_set_inframode(ifh, 1));

    // bwl_set_channel -> 11 -> Fail
    PRINT_ERROR_IF_SUCCESS(bwl_set_channel(ifh, 11));

    // -------------------------------------------------------------------
    // CLASS3 To CLASS1
    ToClass1();
    // -------------------------------------------------------------------

    EventRxCallback();

    // -------------------------------------------------------------------
    /*
    // bwl_join
    uint8_t ssid[] = "SSID";
    PRINT_ERROR_IF_SUCCESS(bwl_join(ifh, ssid, sizeof(ssid)));
    */

    // bwl_create
    PRINT_ERROR_IF_SUCCESS(bwl_create(ifh, TEST_SSID, strlen(reinterpret_cast<const char *>(TEST_SSID))));


    // -------------------------------------------------------------------
    struct ether_addr ether_bcast = {{255, 255, 255, 255, 255, 255}};
    // bwl_disassoc
    PRINT_ERROR_IF_SUCCESS(bwl_disassoc(ifh));

    // bwl_deauth
    PRINT_ERROR_IF_FAILED(bwl_deauth(ifh, &ether_bcast, DOT11_RC_DEAUTH_LEAVING));


    // -------------------------------------------------------------------
    // bwl_send_periodic_af
    //  int32_t bwl_send_periodic_af(void *ifh, uint8_t *data, uint16_t length,
    //          struct ether_addr *bssid, struct ether_addr *destmac,
    //          uint32_t count, uint32_t interval);
    {
        uint8_t data[] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff};
        uint16_t length = 16;
        struct ether_addr bssid = {{0x00, 0x11, 0x22, 0x33, 0x44, 0x55 }};
        struct ether_addr destmac = {{255, 255, 255, 255, 255, 255}};

        PRINT_ERROR_IF_FAILED(bwl_send_periodic_af(ifh, data, length, &bssid, &destmac, 10, 100));
    }

    // bwl_cancel_periodic_af
    PRINT_ERROR_IF_FAILED(bwl_cancel_periodic_af(ifh));

    // bwl_send_one_af
    //  int32_t bwl_send_one_af(void *ifh, uint8_t *data, uint16_t length,
    //          struct ether_addr *bssid, struct ether_addr *destmac,
    //          uint32_t channel, uint32_t dwell);
    {
        uint8_t data[] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff};
        uint16_t length = 16;
        struct ether_addr bssid = {{0x00, 0x11, 0x22, 0x33, 0x44, 0x55 }};
        struct ether_addr destmac = {{255, 255, 255, 255, 255, 255}};

        PRINT_ERROR_IF_FAILED(bwl_send_one_af(ifh, data, length, &bssid, &destmac, 11, 100));
    }

    // -------------------------------------------------------------------
    // bwl_add_afsubtype
    uint8_t subtypes[8] = {0, 1, 2, 3, 127, 128, 254, 255};
    for(int i = 0; i<8; i++)
    {
        PRINT_ERROR_IF_FAILED(bwl_add_afsubtype(ifh, subtypes[i]));
    }

    // bwl_get_afsubtypelist
    uint8_t subtypesbuf[8];
    PRINT_ERROR_IF_FAILED(bwl_get_afsubtypelist(ifh, subtypesbuf, 8));
    if(memcmp(subtypes, subtypesbuf, 8) != 0)
    {
        PRINT_ERROR();
    }

    // bwl_clear_afsubtypes
    uint8_t subtypeszero[8] = {0};
    PRINT_ERROR_IF_FAILED(bwl_clear_afsubtypes(ifh));
        PRINT_ERROR_IF_FAILED(bwl_get_afsubtypelist(ifh, subtypesbuf, 8));
        if(memcmp(subtypeszero, subtypesbuf, 8) != 0)
        {
            PRINT_ERROR();
        }


    // -------------------------------------------------------------------
    // bwl_set_ds3mode
    PRINT_ERROR_IF_SUCCESS(bwl_set_ds3mode(ifh, 1));

    // bwl_get_ds3mode
    {
        uint32_t mode;
        PRINT_ERROR_IF_FAILED(bwl_get_ds3mode(ifh, &mode));
        if(mode != 1)
        {
            PRINT_ERROR();
        }
    }

    // -------------------------------------------------------------------
    // bwl_set_bcnlossthresh
    PRINT_ERROR_IF_FAILED(bwl_set_bcnlossthresh(ifh, 10));

    // bwl_get_bcnlossthresh
    {
        uint32_t bcnlossthresh;
        PRINT_ERROR_IF_FAILED(bwl_get_bcnlossthresh(ifh, &bcnlossthresh));
        if(bcnlossthresh != 10)
        {
            PRINT_ERROR();
        }
    }

TEST_LEAVE();
}

void Test::Sta_Idle()
{
    Ap_Idle();
}

void Test::Sta_Class1()
{
    Ap_Class1();
}

void Test::Sta_Class3()
{
    Ap_Class3();
}




int Test::CbFunc_rxevent(void *_event, void *buf)
{
    struct osl_info {
        uint magic;
        void *pdev;
        uint bustype;
        void *bus_handle;
    };

    uint32_t *type = reinterpret_cast<uint32_t *>(_event);
    wl_event_msg_t *ev = reinterpret_cast<wl_event_msg_t *>(_event);

    NN_LOG("<WLAN_TEST> [%s(%d) ver:%d event:%d len:%d size:%d]\n",__FUNCTION__, __LINE__,
                ev->version, ev->event_type, ev->datalen, sizeof(wl_event_msg_t));

    switch(ev->event_type)
    {

    case WLC_E_ESCAN_RESULT:
/*        {
        osl_info *osl = reinterpret_cast<osl_info *>(reinterpret_cast<char *>(buf) + sizeof(wl_event_msg_t));

        NN_LOG("<WLAN_TEST> [%s(%d) ver:%d event:%d len:%d bus_handle=0x%x]\n",__FUNCTION__, __LINE__,
            ev->version, ev->event_type, ev->datalen, osl->bus_handle);
        //dump_bss_info(reinterpret_cast<void *>(reinterpret_cast<char *>(osl->bus_handle) + 0x0070));

        nn::mbuf::Mbuf *pMbuf = reinterpret_cast<nn::mbuf::Mbuf *>(osl->bus_handle);
        dump_bss_info(nn::mbuf::MbufTod(pMbuf));
        }
*/
        CbFunc_rxdata(buf);
        break;

    default:
        nn::os::SignalEvent(&event);
        osl_info *osl = reinterpret_cast<osl_info *>(reinterpret_cast<char *>(buf) + sizeof(wl_event_msg_t));


        NN_LOG("<WLAN_TEST> [%s(%d) magic:0x%x pdef:0x%x bustype:0x%x bus_handle=0x%x size=%d]\n",__FUNCTION__, __LINE__,
                    osl->magic, osl->pdev, osl->bustype, osl->bus_handle, sizeof(osl_info));
        BinaryDump(ev, (ev->datalen > 256)?256:ev->datalen , 1);
        /*
        BinaryDump(osl->bus_handle, ev->datalen , 1);
        if(ev->event_type == WLC_E_ESCAN_RESULT)
        {
            dump_bss_info(reinterpret_cast<void *>(reinterpret_cast<char *>(osl->bus_handle) + 0x0070));
        }
         */
        break;
    }

    nn::mbuf::MbufFreem(reinterpret_cast<nn::mbuf::Mbuf *>(buf));
    return 0;
}

int Test::CbFunc_txcompletion(void *buf , int result)
{
    nn::mbuf::Mbuf *pMbuf = reinterpret_cast<nn::mbuf::Mbuf *>(buf);
    NN_LOG("<WLAN_TEST> [%s(%d)] top=0x%x result=%d\n",__FUNCTION__, __LINE__, pMbuf->_top, result);
    BinaryDump(buf, (pMbuf->_len > 256 ? 256: pMbuf->_len), 1);

    return 0;
}

int Test::CbFunc_rxdata(void *buf)
{
    nn::mbuf::Mbuf *pMbuf = reinterpret_cast<nn::mbuf::Mbuf *>(buf);

        NN_LOG("<WLAN_TEST> [%s(%d) protcol=%d top=0x%x len=%d]\n",__FUNCTION__, __LINE__,
                pMbuf->_protocol, pMbuf->_top, pMbuf->_len);
        BinaryDump(buf, pMbuf->_len , 1);

    return 0;
}

void Test::EventRxCallback()
{
    dhd_register_txcompletion_cb(ifh, &CbFunc_txcompletion);
    dhd_register_rxdata_cb(ifh, &CbFunc_rxdata);
    dhd_register_event_cb(ifh, &CbFunc_rxevent);

}
#if 1

char *
local_wl_ether_etoa(const struct ether_addr *n)
{
    static char etoa_buf[ETHER_ADDR_LEN * 3];
    char *c = etoa_buf;
    int i;

    for (i = 0; i < ETHER_ADDR_LEN; i++) {
        if (i)
            *c++ = ':';
        c += sprintf(c, "%02X", n->octet[i] & 0xff);
    }
    return etoa_buf;
}

void
Test::dump_bss_info(void *wbi)
{
#define SSID_FMT_BUF_LEN (4*32+1)    //NOLINT(preprocessor/const)
    wl_scan_results_t *scanresult = reinterpret_cast<wl_scan_results_t *>(wbi);
    wl_bss_info_t *bi = scanresult->bss_info;
    char ssidbuf[SSID_FMT_BUF_LEN];
    char chspec_str[CHANSPEC_STR_LEN];
    wl_bss_info_107_t *old_bi;
    int mcs_idx = 0, start_idx = 0;
    bool start_idx_valid = FALSE;
    uint16 capability;

    /* Convert version 107 to 109 */
    if ((bi->version) == LEGACY_WL_BSS_INFO_VERSION) {
        old_bi = (wl_bss_info_107_t *)bi;
        bi->chanspec = CH20MHZ_CHSPEC(old_bi->channel);
        bi->ie_length = old_bi->ie_length;
        bi->ie_offset = sizeof(wl_bss_info_107_t);
    } else {
        /* do endian swap and format conversion for chanspec if we have
         * not created it from legacy bi above
         */
        //bi->chanspec = wl_chspec32_from_driver(bi->chanspec);
    }

    //wl_format_ssid(ssidbuf, bi->SSID, bi->SSID_len);


    NN_LOG("SSID: \"%s\"\n", bi->SSID);

    NN_LOG("Mode: %x\t", bi->capability);
    NN_LOG("RSSI: %d dBm\t", (int16)((bi->RSSI)));

    /*
     * SNR has valid value in only 109 version.
     * So print SNR for 109 version only.
     */
    if ((bi->version) == WL_BSS_INFO_VERSION) {
        NN_LOG("SNR: %d dB\t", (int16)((bi->SNR)));
    }

    NN_LOG("noise: %d dBm\t", bi->phy_noise);
    if (bi->flags) {
        uint16 flags = (bi->flags);
        NN_LOG("Flags: ");
        if (flags & WL_BSS_FLAGS_FROM_BEACON)
            NN_LOG("FromBcn ");
        if (flags & WL_BSS_FLAGS_FROM_CACHE)
            NN_LOG("Cached ");
        if (flags & WL_BSS_FLAGS_RSSI_ONCHANNEL)
            NN_LOG("RSSI on-channel ");
        NN_LOG("\t");
    }
    NN_LOG("Channel: %X\n", bi->chanspec);

    NN_LOG("BSSID: %s\t", local_wl_ether_etoa(&bi->BSSID));

    NN_LOG("Capability: ");
    capability = (bi->capability);
    if (capability & DOT11_CAP_ESS)
        NN_LOG("ESS ");
    if (capability & DOT11_CAP_IBSS)
        NN_LOG("IBSS ");
    if (capability & DOT11_CAP_POLLABLE)
        NN_LOG("Pollable ");
    if (capability & DOT11_CAP_POLL_RQ)
        NN_LOG("PollReq ");
    if (capability & DOT11_CAP_PRIVACY)
        NN_LOG("WEP ");
    if (capability & DOT11_CAP_SHORT)
        NN_LOG("ShortPre ");
    if (capability & DOT11_CAP_PBCC)
        NN_LOG("PBCC ");
    if (capability & DOT11_CAP_AGILITY)
        NN_LOG("Agility ");
    if (capability & DOT11_CAP_SHORTSLOT)
        NN_LOG("ShortSlot ");
    if (capability & DOT11_CAP_RRM)
        NN_LOG("RRM ");
    if (capability & DOT11_CAP_CCK_OFDM)
        NN_LOG("CCK-OFDM ");
    NN_LOG("\n");

    NN_LOG("Supported Rates: 0x%x count %d", bi->rateset.rates, bi->rateset.count);
    NN_LOG("\n");
/*
    if ((bi->ie_length))
        wl_dump_wpa_rsn_ies((uint8 *)(((uint8 *)bi) + (bi->ie_offset)),
                            (bi->ie_length));
*/
    if ((bi->version) != LEGACY_WL_BSS_INFO_VERSION && bi->n_cap) {
        if (bi->vht_cap)
            NN_LOG("VHT Capable:\n");
        else
            NN_LOG("HT Capable:\n");
        if (CHSPEC_IS8080(bi->chanspec)) {
/*
            NN_LOG("\tChanspec: 5GHz channel %d-%d 80+80MHz (0x%x)\n",
             wf_chspec_primary80_channel(bi->chanspec),
             wf_chspec_secondary80_channel(bi->chanspec),
             bi->chanspec);
*/
        }
        else {
            NN_LOG("\tChanspec: %sGHz channel %d %dMHz (0x%x)\n",
                CHSPEC_IS2G(bi->chanspec)?"2.4":"5", CHSPEC_CHANNEL(bi->chanspec),
                (CHSPEC_IS160(bi->chanspec) ?
                160:(CHSPEC_IS80(bi->chanspec) ?
                80 : (CHSPEC_IS40(bi->chanspec) ?
                40 : (CHSPEC_IS20(bi->chanspec) ? 20 : 10)))),
                bi->chanspec);
        }
        NN_LOG("\tPrimary channel: %d\n", bi->ctl_ch);
        NN_LOG("\tHT Capabilities: ");
        if ((bi->nbss_cap) & HT_CAP_40MHZ)
            NN_LOG("40Mhz ");
        if ((bi->nbss_cap) & HT_CAP_SHORT_GI_20)
            NN_LOG("SGI20 ");
        if ((bi->nbss_cap) & HT_CAP_SHORT_GI_40)
            NN_LOG("SGI40 ");
        NN_LOG("\n\tSupported HT MCS :");
        for (mcs_idx = 0; mcs_idx < (MCSSET_LEN * 8); mcs_idx++) {
            if (isset(bi->basic_mcs, mcs_idx) && !start_idx_valid) {
                NN_LOG(" %d", mcs_idx);
                start_idx = mcs_idx;
                start_idx_valid = TRUE;
            }

            if (!isset(bi->basic_mcs, mcs_idx) && start_idx_valid) {
                if ((mcs_idx - start_idx) > 1)
                    NN_LOG("-%d", (mcs_idx - 1));
                start_idx_valid = FALSE;

            }
        }
        NN_LOG("\n");

        if (bi->vht_cap) {
            int i;
            uint mcs, rx_mcs, prop_mcs = VHT_PROP_MCS_MAP_NONE;
            char mcs_str[16], rx_mcs_str[16];

            if (bi->vht_mcsmap) {
                NN_LOG("\tNegotiated VHT MCS:\n");
                for (i = 1; i <= VHT_CAP_MCS_MAP_NSS_MAX; i++) {
                    mcs = VHT_MCS_MAP_GET_MCS_PER_SS(i, (bi->vht_mcsmap));

                    if ((bi->length) >= (OFFSETOF(wl_bss_info_t,
                        vht_mcsmap_prop) + (bi->ie_length) +
                        sizeof(uint16))) {
                        prop_mcs = VHT_MCS_MAP_GET_MCS_PER_SS(i,
                            (bi->vht_mcsmap_prop));
                    }
                    strcpy(mcs_str,
                        (mcs == VHT_CAP_MCS_MAP_0_9 ? "0-9 " :
                        (mcs == VHT_CAP_MCS_MAP_0_8 ? "0-8 " :
                        (mcs == VHT_CAP_MCS_MAP_0_7 ? "0-7 " :
                         " -- ")))
                         );
                    if (prop_mcs != VHT_PROP_MCS_MAP_NONE)
                        strcpy(mcs_str,
                            (mcs == VHT_CAP_MCS_MAP_0_9 ? "0-11      " :
                            (mcs == VHT_CAP_MCS_MAP_0_8 ? "0-8, 10-11" :
                            (mcs == VHT_CAP_MCS_MAP_0_7 ? "0-7, 10-11" :
                             "    --    ")))
                             );

                    if (mcs != VHT_CAP_MCS_MAP_NONE) {
                        NN_LOG("\t\tNSS%d : %s \n", i,
                            mcs_str);
                    }
                }
            } else {
                NN_LOG("\tSupported VHT MCS:\n");
                for (i = 1; i <= VHT_CAP_MCS_MAP_NSS_MAX; i++) {
                    mcs = VHT_MCS_MAP_GET_MCS_PER_SS(i,
                        (bi->vht_txmcsmap));

                    rx_mcs = VHT_MCS_MAP_GET_MCS_PER_SS(i,
                        (bi->vht_rxmcsmap));

                    if ((bi->length) >= (OFFSETOF(wl_bss_info_t,
                        vht_txmcsmap_prop) + (bi->ie_length) +
                        sizeof(uint16))) {
                        prop_mcs = VHT_MCS_MAP_GET_MCS_PER_SS(i,
                            (bi->vht_txmcsmap_prop));
                    }

                    strcpy(mcs_str,
                        (mcs == VHT_CAP_MCS_MAP_0_9 ? "0-9 " :
                        (mcs == VHT_CAP_MCS_MAP_0_8 ? "0-8 " :
                        (mcs == VHT_CAP_MCS_MAP_0_7 ? "0-7 " : " -- "))));
                    if (prop_mcs != VHT_PROP_MCS_MAP_NONE)
                        strcpy(mcs_str,
                            (mcs == VHT_CAP_MCS_MAP_0_9 ? "0-11      " :
                            (mcs == VHT_CAP_MCS_MAP_0_8 ? "0-8, 10-11" :
                            (mcs == VHT_CAP_MCS_MAP_0_7 ? "0-7, 10-11" :
                             "    --    ")))
                            );

                    strcpy(rx_mcs_str ,
                        (rx_mcs == VHT_CAP_MCS_MAP_0_9 ? "0-9 " :
                        (rx_mcs == VHT_CAP_MCS_MAP_0_8 ? "0-8 " :
                        (rx_mcs == VHT_CAP_MCS_MAP_0_7 ? "0-7 " : " -- "))));
                    if (prop_mcs != VHT_PROP_MCS_MAP_NONE)
                        strcpy(rx_mcs_str,
                            (rx_mcs == VHT_CAP_MCS_MAP_0_9 ? "0-11      " :
                            (rx_mcs == VHT_CAP_MCS_MAP_0_8 ? "0-8, 10-11" :
                            (rx_mcs == VHT_CAP_MCS_MAP_0_7 ? "0-7, 10-11" :
                             "    --    ")))
                             );

                    if ((mcs != VHT_CAP_MCS_MAP_NONE) ||
                        (rx_mcs != VHT_CAP_MCS_MAP_NONE)) {
                        NN_LOG("\t\tNSS%d Tx: %s  Rx: %s\n", i,
                            mcs_str, rx_mcs_str);
                    }
                }
            }
        }
       //bi->chanspec = wl_chspec32_to_driver(bi->chanspec);
    }
/*
    if ((bi->ie_length))
    {
        wl_dump_wps((uint8 *)(((uint8 *)bi) + (bi->ie_offset)),
            (bi->ie_length));
    }
*/
    if ((bi->flags) & WL_BSS_FLAGS_HS20) {
        NN_LOG("Hotspot 2.0 capable\n");
    }
/*
    if (bcm_find_vs_ie((uint8 *)(((uint8 *)bi) + (bi->ie_offset)),
        (bi->ie_length),
        (uint8 *)WFA_OUI, WFA_OUI_LEN, WFA_OUI_TYPE_OSEN) != NULL) {
        NN_LOG("OSEN supported\n");
    }
*/
    NN_LOG("\n");
} //NOLINT(impl/function_size)
#endif


}
}

