﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include "shell_Console.h"

namespace nn { namespace shell {

class TelnetBufferedWriter : public BufferedWriter
{
public:
    TelnetBufferedWriter(int streamId, char* writeBuffer, int writeBufferLength) NN_NOEXCEPT;
protected:
    virtual bool Write(char* pBuffer, int length) NN_NOEXCEPT;
private:
    int                     m_StreamId;
};

class TelnetConsole : public Console
{
public:
    explicit TelnetConsole(int socket) NN_NOEXCEPT;
    ~TelnetConsole() NN_NOEXCEPT;
    bool Negotiate() NN_NOEXCEPT;

protected:
    virtual void PutChar(int c) NN_NOEXCEPT;
    virtual void FlushCore() NN_NOEXCEPT;
    virtual int GetChar() NN_NOEXCEPT;

private:
    static const int BufferLength = 128;

    void ProcessCommand(int command) NN_NOEXCEPT;
    int GetCharRaw() NN_NOEXCEPT;
    int GetCharRawHtcs() NN_NOEXCEPT;

    int                     m_StreamId;
    TelnetBufferedWriter    m_Writer;
    char                    m_WriteBuffer[BufferLength];
};


}}    // namespace nn { namespace shell {
