﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace shell {

class Console;
class CommandExecutorSet;
struct InputCommand;

class Shell
{
public:
    Shell(Console* pConsole, CommandExecutorSet* pExecutorSet) NN_NOEXCEPT;
    void Run() NN_NOEXCEPT;

private:
    int64_t Execute(InputCommand* command) NN_NOEXCEPT;

    Console*            m_pConsole;
    CommandExecutorSet* m_pExecutorSet;
};

}}    // namespace nn { namespace shell {
