﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/fs.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/nn_Assert.h>
#include <nn/os/os_Mutex.h>

#include "shell_HtcsLibraryAllocator.h"

using namespace nn::lmem;

namespace nn { namespace shell { namespace detail {

namespace {
HeapHandle g_HtcsLibraryHeapHandle;
const size_t HtcsLibraryHeapSize = 2 * 1024;
char       g_HtcsLibraryHeap[HtcsLibraryHeapSize];

// TODO: lmem がマルチスレッド対応したら、mutex を削除
nn::os::Mutex mutex(true);

void InitializeHtcsLibraryHeap()
{
    std::lock_guard<nn::os::Mutex> scopedLock(mutex);
    g_HtcsLibraryHeapHandle = CreateExpHeap(g_HtcsLibraryHeap, HtcsLibraryHeapSize, CreationOption_NoOption);
    NN_ASSERT_NOT_NULL(g_HtcsLibraryHeapHandle);
}
} // namespace

void* HtcsLibraryHeapAllocate(size_t size)
{
    std::lock_guard<nn::os::Mutex> scopedLock(mutex);
    return AllocateFromExpHeap(g_HtcsLibraryHeapHandle, size);
}

void HtcsLibraryHeapDeallocate(void* p, size_t size)
{
    std::lock_guard<nn::os::Mutex> scopedLock(mutex);
    NN_UNUSED(size);
    return FreeToExpHeap(g_HtcsLibraryHeapHandle, p);
}


void InitializeHtcsLibraryAllocator()
{
    InitializeHtcsLibraryHeap();
}

}}}
