﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <algorithm>
#include <random>
#include <nn/svc/svc_Base.h>
#include <nn/nn_Abort.h>

#include "ro_Random.h"

namespace nn { namespace ro { namespace random {
namespace
{
std::mt19937 g_Random;
bool g_RandomInitialized = false;
}

void Initialize() NN_NOEXCEPT
{
    NN_ABORT_UNLESS(!g_RandomInitialized);
    Bit64 value;
    auto result = nn::svc::GetInfo(&value, svc::InfoType_Random, nn::svc::Handle(0), 2);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    g_Random.seed(value);
    g_RandomInitialized = true;
}

uint64_t GetValue(uint64_t randMax) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_RandomInitialized);
    std::uniform_int_distribution<uint64_t> rand(0, randMax);
    return rand(g_Random);
}

}}}  // nn::ro::random
