﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ro_DebugMonitor.h"
#include "ro_RoServer.h"

namespace nn { namespace ro {

    nn::Result DebugMonitor::GetProcessModuleInfo(int* pOutCount, ModuleInfo* pBuffer, int num, nn::os::ProcessId id) NN_NOEXCEPT
    {
        *pOutCount = 0;
        std::memset(pBuffer, 0, num * sizeof(ModuleInfo));
        return RoServer::GetProcessModuleInfo(pOutCount, pBuffer, num, id);
    }

}}  // nn::ldr
