﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace profiler {

void SetTrampolineAddresses(uint64_t* trampolines, int count);
nn::Result InstrumentFunction(uint64_t funcAddress, int slot);
nn::Result InstrumentRemoval(int slot);
uint64_t GetFunctionAddressForSlot(int slot);
void ResetInstrumentation();

namespace /*anonymous*/
{

inline bool IsValidCodeAddress(uintptr_t address)
{
    // The profiler internally may use either of these values to indicate invalid values.
    // This provides a quick check on validity before using TargetApplication to do a more in-depth query.
    return (!(address == 0 || address == UINTPTR_MAX));
}

} // anonymous

} // profiler
} // nn
