﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Types.h>

#include "pmu/profiler_PerfCounterGroups.h"

namespace nn { namespace profiler {

struct SettingsFromThePcGui
{
public:
    uint32_t version;

    enum FlagBits : uint32_t
    {
        UseSimple               = (1 << 0),
        // UseTimestamps        = (1 << 1), (timestamps are required)
        SampleByPerfCounter     = (1 << 2),
        // UseRingBuffer        = (1 << 3), (ring buffer no longer supported)
        UseInstrumented         = (1 << 4),
        // ActivateCodeBlocks   = (1 << 5), (always active)
        RecordSimpleStackDepths = (1 << 6),
        // RecordPowerStats     = (1 << 7), (can no longer be recorded by runtime)
        UseOutOfProcessSampling = (1 << 8),

        // Mask bits for all available FlagBits.
        FlagBit_MASK            = ((1 << 9) - 1),
    };

    // set from FlagBits
    uint32_t  flags;

    // overload as "units between samples" when using performance counters instead
    //  of time
    uint32_t  requested_time_between_samples_in_nanoseconds;

    // one of sdsg::ctrprof::per_core_pmnc_event_type or the "not used" token of
    //  0x100.
    uint16_t   perf_counters[pmu::PerformanceCounterCount];

    // really only needs to be a u8 -- using a u32 for padding issues
    uint32_t  perf_counter_cycle;

    uint32_t  padding1; // padding due to 8-byte alignment for 64-bit values

    nn::os::ThreadId  reserved;

    // If ARM last bit should be '0'. If THUMB last bit should be '1'.
    uint64_t func_to_instrument;
    uint64_t arm_trampoline1;

    // Determination of which cores to profile
    uint32_t coreMask;

    uint32_t padding2; // padding due to 8-byte struct alignment due to 64-bit values

public:
    inline bool IsInProcess()
    {
        return ((flags & UseOutOfProcessSampling) == 0);
    }

    inline bool IsOutOfProcess()
    {
        return ((flags & UseOutOfProcessSampling) != 0);
    }
};

}} // nn::profiler
