﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace profiler {

//
// Sampling Offset
//  This class is used to provide a random offset after some of the events that
//  cause a profiler break. Use of this class helps maintain profiler accuracy
//  so that we get an effective comb of the profiled application.
class SamplingOffset
{
public:
    SamplingOffset();

    void SetBaseValue(uint32_t baseValue);

    uint32_t GetNextOffset();

private:
    // This algortihm is of the class "Xorshift RNG".
    // It produces random 32-bit numbers.
    uint32_t xor_rand();

    uint32_t GetOffset() NN_NOINLINE;

private:
    // This value is used to offset our random offset to guarnatee a specific range.
    static const uint32_t MINIMUM_OFFSET = 100;

    uint32_t m_maxValue;
    int32_t m_currentOffset;
    int32_t m_randomSeed;
};

} // profiler
} // nn
