﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/profiler/profiler_Types.h>

namespace nn { namespace profiler {

enum IpcEvent : uint32_t
{
    IpcEvent_Status,
    IpcEvent_MessageCallback,
    IpcEvent_PcMessageForward,
    IpcEvent_InstrumentationBuffer,
    IpcEvent_SendData,
};

enum InstrumentationBufferType : uint32_t
{
    InstrumentationBufferType_Start,
    InstrumentationBufferType_Stop,
};

struct IpcInfoStatus
{
    ProfilerStatus status;
};

struct IpcInfoMessageCallback
{
    uint32_t id;
    uint32_t resultCode;
};

struct IpcInfoPcMessageForward
{
    uint32_t message;
    uint32_t size;
    uint64_t smallPayload;
};

struct IpcInfoInstrumentationBuffer
{
    InstrumentationBufferType type;
};

struct IpcInfoSendData
{
    // Nothing
    uint32_t padding;
};

union IpcInfo
{
    IpcInfoStatus status;
    IpcInfoMessageCallback messageCallback;
    IpcInfoPcMessageForward pcMessageForward;
    IpcInfoInstrumentationBuffer instrumentationBuffer;
    IpcInfoSendData sendData;
};

struct IpcEventInfo
{
    IpcEvent event;
    IpcInfo info;
};

}} // nn::profiler
