﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#define NN_NOTAILCALL __attribute__((disable_tail_calls))

#define VERSION_NUMBER(major, minor, micro, relstep) \
    ((major) << 24) | ((minor) << 16) | ((micro) << 8) | (relstep)

namespace nn { namespace profiler {

// Library version numbers
const uint32_t ProfilerRuntimeVersion = VERSION_NUMBER(0, 11, 0, 0);
const uint32_t ProfilerMinGuiVersion = VERSION_NUMBER(0, 11, 0, 0);

// Structure version numbers
const uint32_t ProfilerHeaderVersion = VERSION_NUMBER(2, 0, 0, 0);
const uint32_t ProfilerApplicationInfoVersion = 0x0004u;

// Determines the number of thread ids that we can track in the runtime
// Ideally should be a multiple of 8
const size_t ThreadIdListSize = 64;
const nn::Bit64 DebugEventSystemSleepThreadId = 0xffffffffffffffffull;
const nn::Bit64 DebugEventOtherProcessThreadId = 0xfffffffffffffffeull;

const uint32_t SupportedCoreCount = 4u;
const uint32_t SupportedCoreMask = (1 << SupportedCoreCount) - 1;

const size_t MaximumFilePathLength = 512;

const size_t StackEntry = sizeof(uintptr_t) + sizeof(uint32_t);
const size_t SentinelSize = StackEntry * 40;
const size_t LastDitchSentinel = SentinelSize - (StackEntry * 8);

const int ProfilerPrimaryCore = 3;

namespace // anonymous
{
    inline uint64_t MicrosecondsToNanoseconds(uint64_t us)
    {
        return us * 1000uL;
    }

    inline uint64_t MillisecondsToNanoseconds(uint64_t ms)
    {
        return ms * 1000000uL;
    }

    inline uint64_t SecondsToNanoseconds(uint64_t seconds)
    {
        return seconds * 1000000000uL;
    }
} // anonymous

}} // nn::profiler
