﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ns_NotificationAgentProxy.h"

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/ovln/ovln_NotificationAgent.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_DefaultAllocationPolicy.h>
#include <nn/ovln/ovln_Services.sfdl.h>
#include <nn/os/os_Thread.h>
#include <nn/nn_SystemThreadDefinition.h>

#include <nn/ovln/ovln_LibraryCore.h>

namespace nn { namespace ns {

const int MaxClientCount = 20;

namespace {

struct MyHipcServerManagerOption
{
    static const bool CanDeferInvokeRequest = false;
    static const int SubDomainCountMax = MaxClientCount;
    static const int ObjectInSubDomainCountMax = MaxClientCount * 3;
};

class MyHipcServerManager
    : public nn::sf::HipcSimpleAllInOneServerManager<MaxClientCount, 2, MyHipcServerManagerOption>
{
};

MyHipcServerManager g_MyHipcServerManager;
NN_OS_ALIGNAS_THREAD_STACK char g_MyHipcServerManagerThreadStack[1024 * 16];
nn::os::ThreadType g_MyHipcServerManagerThread;

void MyHipcServerManagerThreadFunction(void*)
{
    g_MyHipcServerManager.LoopAuto();
}

}

void InitializeNotificationSenderAndReceiverLibraryForServer() NN_NOEXCEPT
{
    auto p = nn::ovln::CreateNotificationAgent(nn::sf::GetNewDeleteMemoryResource());
    nn::ovln::GetReceiverServiceShimLibraryObjectHolder().InitializeHolderDirectly(nn::ovln::GetReceiverService(p));
    nn::ovln::GetSenderServiceShimLibraryObjectHolder().InitializeHolderDirectly(nn::ovln::GetSenderService(p));
}

void RegisterNotificationAgentProxy() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_MyHipcServerManager.RegisterObjectForPort(nn::ovln::GetReceiverServiceShimLibraryObjectHolder().GetObject(), 2, "ovln:rcv"));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_MyHipcServerManager.RegisterObjectForPort(nn::ovln::GetSenderServiceShimLibraryObjectHolder().GetObject(), MaxClientCount, "ovln:snd"));
}

void StartNotificationAgentProxy() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(&g_MyHipcServerManagerThread, MyHipcServerManagerThreadFunction, nullptr, g_MyHipcServerManagerThreadStack, sizeof(g_MyHipcServerManagerThreadStack), NN_SYSTEM_THREAD_PRIORITY(ns, NotificationAgentProxyIpcSession)));
    nn::os::SetThreadNamePointer(&g_MyHipcServerManagerThread, NN_SYSTEM_THREAD_NAME(ns, NotificationAgentProxyIpcSession));
    nn::os::StartThread(&g_MyHipcServerManagerThread);
}

}}
