﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/ns/srv/ns_IEventHandler.h>

#include "ns_Infrastructure.h"

namespace nn { namespace ns {

    namespace
    {
        MyServerManager g_ServerManager;
    }

    MyServerManager* GetServerManager()
    {
        return &g_ServerManager;
    }

    void LoopServerWithEventHandler()
    {
        while (auto p = g_ServerManager.Wait())
        {
            auto userData = nn::os::GetMultiWaitHolderUserData(p);

            switch (userData)
            {
            case MyServerManager::InvokeTag:
            case MyServerManager::AcceptTag:
                {
                    NN_ABORT_UNLESS_RESULT_SUCCESS(
                        g_ServerManager.ProcessAuto(p) );
                }
                break;

            default:
                {
                    reinterpret_cast<nn::ns::srv::IEventHandler*>(userData)->HandleEvent();
                }
                break;
            }
        }
    }

}}  // namespace nn::ns

