﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nn/os.h>

namespace nn {
namespace npns {

    template<typename typeT, size_t count>
    class TypedMessageQueue : public nn::os::MessageQueue
    {
    public:
        TypedMessageQueue()
            : MessageQueue(m_Array, count)
        {
        }
        void Send(typeT data)
        {
            MessageQueue::Send(reinterpret_cast<uintptr_t>(data));
        }
        bool TrySend(typeT data)
        {
            return MessageQueue::TrySend(reinterpret_cast<uintptr_t>(data));
        }
        void Jam(typeT data)
        {
            MessageQueue::Jam(reinterpret_cast<uintptr_t>(data));
        }
        bool TryJam(typeT data)
        {
            return MessageQueue::TryJam(reinterpret_cast<uintptr_t>(data));
        }
        typeT Receive()
        {
            uintptr_t out;
            MessageQueue::Receive(&out);
            return reinterpret_cast<typeT>(out);
        }
        bool TryReceive(typeT* pOut)
        {
            return MessageQueue::TryReceive(reinterpret_cast<uintptr_t*>(pOut));
        }
        typeT GetFront()
        {
            uintptr_t out;
            MessageQueue::Peek(&out);
            return reinterpret_cast<typeT>(out);
        }
        bool TryGetFront(typeT* pOut)
        {
            return MessageQueue::TryPeek(reinterpret_cast<uintptr_t*>(pOut));
        }
        bool IsEmpty()
        {
            uintptr_t out;
            return !MessageQueue::TryPeek(reinterpret_cast<uintptr_t*>(&out));
        }
    private:
        uintptr_t m_Array[count];
    };
}
}
