﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/psc.h>
#include <nn/bgsu/bgsu_ThreadTemplate.h>
#include <nn/bgsu/bgsu_PowerStateEventHandler.h>

#include "npns_Config.h"

namespace nn{ namespace npns{

class SystemEventHandlerThread : public bgsu::ThreadTemplate<SystemEventHandlerThread, NN_NPNS_THREAD_STACK_SIZE_EVENT>
                               , public bgsu::PowerStateEventHandler
{
    typedef bgsu::ThreadTemplate<SystemEventHandlerThread, NN_NPNS_THREAD_STACK_SIZE_EVENT> ThreadBase;
public:
    SystemEventHandlerThread();
    ~SystemEventHandlerThread();

    Result Initialize();
    void Finalize();

protected:
    virtual void OnReceivePowerStateEvent(psc::PmState stateLast, psc::PmState stateTo, psc::PmFlagSet flagset);
    void OnReceiveScheduleEvent(os::SystemEvent* pCancelEvent);
    void OnReceiveTriggerEvent(os::SystemEvent* pCancelEvent);

    virtual void ThreadBody();
    virtual void RequestExit();

    void UpdateSchedule();
    bool IsPeriodicIntervalChanged() const;

private:
    int32_t m_CurrentRetryCountOnHalfAwake;
    bgtc::Interval m_CurrentPeriodicInterval;
};

}}
